/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;

public class GrGetPsiTypeAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        PsiFile psiFile = HandlerUtils.getPsiFile(editor, e.getDataContext());
        if (!(psiFile instanceof GroovyFile)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        List<GrExpression> expressions = GrIntroduceHandlerBase.collectExpressions(psiFile, editor, offset, true);
        if (expressions.size() == 0) {
            return;
        }
        if (expressions.size() == 1) {
            GrGetPsiTypeAction.passInner(expressions.get(0));
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<GrExpression>(){

                public void pass(GrExpression grExpression) {
                    GrGetPsiTypeAction.passInner(grExpression);
                }
            }, (Function)new Function<GrExpression, String>(){

                public String fun(GrExpression grExpression) {
                    return grExpression.getText();
                }
            });
        }
    }

    public static void showBalloon(Project project, String message, MessageType messageType) {
        JFrame frame = WindowManager.getInstance().getFrame(project.isDefault() ? null : project);
        if (frame == null) {
            return;
        }
        JRootPane component = frame.getRootPane();
        if (component == null) {
            return;
        }
        Rectangle rect = component.getVisibleRect();
        Point p = new Point(rect.x + rect.width - 10, rect.y + 10);
        RelativePoint point = new RelativePoint((Component)component, p);
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null).setShowCallout(false).setCloseButtonEnabled(true).createBalloon().show(point, Balloon.Position.atLeft);
    }

    public static void passInner(GrExpression expression) {
        PsiType type = expression.getType();
        String text = type == null ? "type is null" : type.getCanonicalText();
        GrGetPsiTypeAction.showBalloon(expression.getProject(), StringUtil.escapeXml((String)text), MessageType.INFO);
    }

    public void update(AnActionEvent e) {
        PsiFile psiFile;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null && (psiFile = HandlerUtils.getPsiFile(editor, e.getDataContext())) instanceof GroovyFile) {
            e.getPresentation().setEnabled(true);
            return;
        }
        e.getPresentation().setEnabled(false);
    }
}

