/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameEditor;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.CloudGitDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.io.File;
import java.util.List;

public class CloudGitDeploymentChecker<T extends CloudDeploymentNameConfiguration, SC extends ServerConfigurationBase, SR extends CloudMultiSourceServerRuntimeInstance<T, ?, ?, ?>> {
    private GitRepositoryManager myGitRepositoryManager;
    private final DeploymentSource myDeploymentSource;
    private final RemoteServer<SC> myServer;
    private final CloudDeploymentNameEditor<T> mySettingsEditor;
    private final CloudGitDeploymentDetector myDetector;

    public CloudGitDeploymentChecker(DeploymentSource deploymentSource, RemoteServer<SC> server, CloudDeploymentNameEditor<T> settingsEditor, CloudGitDeploymentDetector detector) {
        this.myDeploymentSource = deploymentSource;
        this.myServer = server;
        this.mySettingsEditor = settingsEditor;
        this.myDetector = detector;
    }

    public void checkGitUrl(T settings) throws ConfigurationException {
        VirtualFile contentRoot;
        if (!(this.myDeploymentSource instanceof ModuleDeploymentSource)) {
            return;
        }
        ModuleDeploymentSource moduleSource = (ModuleDeploymentSource)this.myDeploymentSource;
        Module module = moduleSource.getModule();
        if (module == null) {
            return;
        }
        File contentRootFile = this.myDeploymentSource.getFile();
        if (contentRootFile == null) {
            return;
        }
        final Project project = module.getProject();
        if (this.myGitRepositoryManager == null) {
            this.myGitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
        }
        if ((contentRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentRootFile)) == null) {
            return;
        }
        GitRepository repository = (GitRepository)this.myGitRepositoryManager.getRepositoryForRoot(contentRoot);
        if (repository == null) {
            return;
        }
        String expectedName = settings.getDeploymentSourceName(this.myDeploymentSource);
        List<String> appNames = this.myDetector.collectApplicationNames(repository);
        if (appNames.isEmpty() || appNames.contains(expectedName)) {
            return;
        }
        RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning("Cloud Git URL found in repository, but it doesn't match the run configuration");
        warning.setQuickFix(new Runnable((CloudDeploymentNameConfiguration)settings){
            final /* synthetic */ CloudDeploymentNameConfiguration val$settings;
            {
                this.val$settings = cloudDeploymentNameConfiguration;
            }

            @Override
            public void run() {
                CloudGitApplication application = (CloudGitApplication)new CloudConnectionTask<CloudGitApplication, SC, T, SR>(project, "Searching for application", CloudGitDeploymentChecker.this.myServer){

                    protected CloudGitApplication run(SR serverRuntime) throws ServerRuntimeException {
                        CloudGitDeploymentRuntime deploymentRuntime = (CloudGitDeploymentRuntime)serverRuntime.createDeploymentRuntime(CloudGitDeploymentChecker.this.myDeploymentSource, val$settings, project);
                        return deploymentRuntime.findApplication4Repository();
                    }
                }.performSync();
                if (application == null) {
                    Messages.showErrorDialog((Component)CloudGitDeploymentChecker.this.mySettingsEditor.getComponent(), (String)"No application matching repository URL(s) found in account");
                } else {
                    CloudDeploymentNameConfiguration fixedSettings = (CloudDeploymentNameConfiguration)CloudGitDeploymentChecker.this.mySettingsEditor.getFactory().create();
                    fixedSettings.setDefaultDeploymentName(false);
                    fixedSettings.setDeploymentName(application.getName());
                    CloudGitDeploymentChecker.this.mySettingsEditor.resetFrom((Object)fixedSettings);
                }
            }
        });
        throw warning;
    }
}

