/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.model.impl;

import com.intellij.util.xmlb.XmlSerializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.android.model.impl.JpsAndroidApplicationArtifactPropertiesSerializer;
import org.jetbrains.jps.android.model.impl.JpsAndroidDexSettingsSerializer;
import org.jetbrains.jps.android.model.impl.JpsAndroidFinalPackageElementSerializer;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;

public class JpsAndroidModelSerializerExtension
extends JpsModelSerializerExtension {
    private static final List<? extends JpsFacetConfigurationSerializer<JpsAndroidModuleExtension>> FACET_PROPERTIES_LOADERS = Arrays.asList(new JpsFacetConfigurationSerializer<JpsAndroidModuleExtension>(JpsAndroidModuleExtensionImpl.KIND, "android", "Android"){

        public JpsAndroidModuleExtension loadExtension(@NotNull Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
            if (facetConfigurationElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension$1", "loadExtension"));
            }
            return new JpsAndroidModuleExtensionImpl((JpsAndroidModuleProperties)XmlSerializer.deserialize((Element)facetConfigurationElement, JpsAndroidModuleProperties.class));
        }

        protected void saveExtension(JpsAndroidModuleExtension extension, Element facetConfigurationTag, JpsModule module) {
            XmlSerializer.serializeInto((Object)((JpsAndroidModuleExtensionImpl)extension).getProperties(), (Element)facetConfigurationTag);
        }
    });
    private static final JpsSdkPropertiesSerializer<JpsSimpleElement<JpsAndroidSdkProperties>> SDK_PROPERTIES_LOADER = new JpsSdkPropertiesSerializer<JpsSimpleElement<JpsAndroidSdkProperties>>("Android SDK", (JpsSdkType)JpsAndroidSdkType.INSTANCE){

        @NotNull
        public JpsSimpleElement<JpsAndroidSdkProperties> loadProperties(@Nullable Element propertiesElement) {
            String jdkName;
            String buildTarget;
            if (propertiesElement != null) {
                buildTarget = propertiesElement.getAttributeValue("sdk");
                jdkName = propertiesElement.getAttributeValue("jdk");
            } else {
                buildTarget = null;
                jdkName = null;
            }
            JpsSimpleElement jpsSimpleElement = JpsElementFactory.getInstance().createSimpleElement((Object)new JpsAndroidSdkProperties(buildTarget, jdkName));
            if (jpsSimpleElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension$2", "loadProperties"));
            }
            return jpsSimpleElement;
        }

        public void saveProperties(@NotNull JpsSimpleElement<JpsAndroidSdkProperties> properties, @NotNull Element element) {
            String buildTarget;
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension$2", "saveProperties"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension$2", "saveProperties"));
            }
            String jdkName = ((JpsAndroidSdkProperties)properties.getData()).getJdkName();
            if (jdkName != null) {
                element.setAttribute("jdk", jdkName);
            }
            if ((buildTarget = ((JpsAndroidSdkProperties)properties.getData()).getBuildTargetHashString()) != null) {
                element.setAttribute("sdk", buildTarget);
            }
        }
    };

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        List<? extends JpsFacetConfigurationSerializer<JpsAndroidModuleExtension>> list = FACET_PROPERTIES_LOADERS;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension", "getFacetConfigurationSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List<JpsAndroidFinalPackageElementSerializer> list = Collections.singletonList(new JpsAndroidFinalPackageElementSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension", "getPackagingElementSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsArtifactPropertiesSerializer<?>> getArtifactTypePropertiesSerializers() {
        List<JpsAndroidApplicationArtifactPropertiesSerializer> list = Collections.singletonList(new JpsAndroidApplicationArtifactPropertiesSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension", "getArtifactTypePropertiesSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsAndroidDexSettingsSerializer> list = Collections.singletonList(new JpsAndroidDexSettingsSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension", "getProjectExtensionSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        List<JpsSdkPropertiesSerializer> list = Arrays.asList(SDK_PROPERTIES_LOADER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/model/impl/JpsAndroidModelSerializerExtension", "getSdkPropertiesSerializers"));
        }
        return list;
    }
}

