/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidResourceCachingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidResourcePackagingBuildTarget
extends AndroidBuildTarget {
    public AndroidResourcePackagingBuildTarget(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "<init>"));
        }
        super(MyTargetType.INSTANCE, module);
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isUseCustomManifestPackage()) {
            out.println(extension.getCustomManifestPackage());
        }
        out.println(extension.getAdditionalPackagingCommandLineParameters());
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        String[] resourceDirs = AndroidJpsUtil.collectResourceDirsForCompilation(extension, true, dataPaths, false);
        ArrayList<String> assertDirs = new ArrayList<String>();
        AndroidResourcePackagingBuildTarget.collectAssetDirs(extension, assertDirs, false);
        File manifestFile = AndroidJpsUtil.getPreprocessedManifestFile(extension, dataPaths);
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (String resourceDir : resourceDirs) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(resourceDir)));
        }
        for (String assetDir : assertDirs) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(assetDir)));
        }
        if (manifestFile != null) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, manifestFile));
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "doComputeRootDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputFile(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "getOutputRoots"));
        }
        return list;
    }

    @NotNull
    public File getOutputFile(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "getOutputFile"));
        }
        File file = AndroidResourcePackagingBuildTarget.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths(), this.myModule);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "getOutputFile"));
        }
        return file;
    }

    @NotNull
    public static File getOutputFile(@NotNull BuildDataPaths dataPaths, @NotNull JpsModule module) {
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "getOutputFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "getOutputFile"));
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        File file = new File(dir.getPath(), module.getName() + ".apk.res");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "getOutputFile"));
        }
        return file;
    }

    public static void collectAssetDirs(@NotNull JpsAndroidModuleExtension extension, @NotNull List<String> result, boolean checkExistence) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "collectAssetDirs"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget", "collectAssetDirs"));
        }
        File assetsDir = extension.getAssetsDir();
        if (assetsDir != null && (!checkExistence || assetsDir.exists())) {
            result.add(assetsDir.getPath());
        }
        if (extension.isIncludeAssetsFromLibraries()) {
            for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
                File depAssetsDir = depExtension.getAssetsDir();
                if (depAssetsDir == null || checkExistence && !depAssetsDir.exists()) continue;
                result.add(depAssetsDir.getPath());
            }
        }
    }

    @Override
    protected void fillDependencies(List<BuildTarget<?>> result) {
        super.fillDependencies(result);
        result.add(new AndroidResourceCachingBuildTarget(this.myModule));
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(this.myModule, true)) {
            result.add(new AndroidResourceCachingBuildTarget(depExtension.getModule()));
        }
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidResourcePackagingBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-resource-packaging", "Resource Packaging");
        }

        @Override
        public AndroidResourcePackagingBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget$MyTargetType", "createBuildTarget"));
            }
            return !extension.isLibrary() ? new AndroidResourcePackagingBuildTarget(extension.getModule()) : null;
        }
    }
}

