/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ClassProvider {
    static final ClassProvider EMPTY = new ClassProvider(){

        @Override
        @Nullable
        public Class lookupClass() {
            return null;
        }

        @Override
        @Nullable
        public String getError() {
            return null;
        }
    };

    ClassProvider() {
    }

    @Nullable
    abstract Class lookupClass();

    @Nullable
    abstract String getError();

    static ClassProvider create(Class clazz) {
        return clazz == null ? EMPTY : new LoadedClassProvider(clazz);
    }

    static ClassProvider create(@Nullable String className, @NotNull ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/ant/dom/ClassProvider", "create"));
        }
        return className == null ? EMPTY : new LazyLoadClassProvider(className, loader);
    }

    private static final class LazyLoadClassProvider
    extends ClassProvider {
        private final String myClassName;
        private final ClassLoader myClassLoader;
        private Pair<Class, String> myResult;

        LazyLoadClassProvider(String className, ClassLoader classLoader) {
            this.myClassName = className;
            this.myClassLoader = classLoader;
        }

        @Override
        @Nullable
        public Class lookupClass() {
            return (Class)this.getResult().getFirst();
        }

        @Override
        @Nullable
        public String getError() {
            return (String)this.getResult().getSecond();
        }

        @NotNull
        private Pair<Class, String> getResult() {
            Pair result = this.myResult;
            if (result == null) {
                Class<?> clazz = null;
                String error = null;
                try {
                    clazz = this.myClassLoader.loadClass(this.myClassName);
                }
                catch (ClassNotFoundException e) {
                    error = "Class not found " + e.getMessage();
                }
                catch (NoClassDefFoundError e) {
                    error = "Class definition not found " + e.getMessage();
                }
                catch (UnsupportedClassVersionError e) {
                    error = "Unsupported class version " + e.getMessage();
                }
                this.myResult = result = Pair.create(clazz, error);
            }
            Pair pair = result;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/ClassProvider$LazyLoadClassProvider", "getResult"));
            }
            return pair;
        }
    }

    private static final class LoadedClassProvider
    extends ClassProvider {
        private final Class myClass;

        LoadedClassProvider(Class clazz) {
            this.myClass = clazz;
        }

        @Override
        @Nullable
        public Class lookupClass() {
            return this.myClass;
        }

        @Override
        @Nullable
        public String getError() {
            return null;
        }
    }
}

