/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntCallParamsFinder;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomProperty;
import com.intellij.lang.ant.dom.AntDomReference;
import com.intellij.lang.ant.dom.AntDomReferenceBase;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.PropertyResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntDomPropertyReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements AntDomReference {
    public static final String ANT_FILE_PREFIX = "ant.file.";
    public static final String ANT_FILE_TYPE_PREFIX = "ant.file.type.";
    private final DomElement myInvocationContextElement;
    private boolean myShouldBeSkippedByAnnotator = false;

    public AntDomPropertyReference(DomElement invocationContextElement, XmlAttributeValue element, TextRange textRange) {
        super((PsiElement)element, textRange, true);
        this.myInvocationContextElement = invocationContextElement;
    }

    @Override
    public boolean shouldBeSkippedByAnnotator() {
        return this.myShouldBeSkippedByAnnotator;
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("unknown.property", this.getCanonicalText());
    }

    @Override
    public void setShouldBeSkippedByAnnotator(boolean value) {
        this.myShouldBeSkippedByAnnotator = value;
    }

    @Nullable
    public PsiElement resolve() {
        MyResolveResult res = this.doResolve();
        return res != null ? res.getElement() : null;
    }

    @Nullable
    private MyResolveResult doResolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? (MyResolveResult)resolveResults[0] : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiElement element = this.getElement();
        PsiFile file = element.getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)MyResolver.INSTANCE, false, incompleteCode, file);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomPropertyReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        AntDomProject project = (AntDomProject)this.myInvocationContextElement.getParentOfType(AntDomProject.class, true);
        if (project != null) {
            Collection variants = (Collection)PropertyResolver.resolve(project.getContextAntProject(), this.getCanonicalText(), this.myInvocationContextElement).getSecond();
            Object[] result = new Object[variants.size()];
            int idx = 0;
            for (String variant : variants) {
                LookupElementBuilder builder = LookupElementBuilder.create((String)variant).withCaseSensitivity(false);
                LookupElement element = AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)builder);
                result[idx++] = element;
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomPropertyReference", "getVariants"));
            }
            return result;
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomPropertyReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        MyResolveResult resolveResult = this.doResolve();
        if (resolveResult != null) {
            PsiElement resolve = resolveResult.getElement();
            PropertiesProvider provider = resolveResult.getProvider();
            String refText = this.getCanonicalText();
            if (provider instanceof AntDomProject) {
                String oldProjectName;
                DomElement resolvedDomElem = AntDomReferenceBase.toDomElement(resolve);
                if (provider.equals(resolvedDomElem) && (oldProjectName = (String)((AntDomProject)provider).getName().getValue()) != null && refText.endsWith(oldProjectName)) {
                    String prefix = refText.substring(0, refText.length() - oldProjectName.length());
                    newElementName = prefix + newElementName;
                }
            } else if (provider instanceof AntDomProperty) {
                AntDomProperty antProperty = (AntDomProperty)provider;
                if (antProperty.equals(AntDomReferenceBase.toDomElement(resolve))) {
                    String envPrefix = (String)antProperty.getEnvironment().getValue();
                    if (envPrefix != null) {
                        if (!envPrefix.endsWith(".")) {
                            envPrefix = envPrefix + ".";
                        }
                        if (refText.startsWith(envPrefix)) {
                            String envVariableName = refText.substring(envPrefix.length());
                            String newPrefix = newElementName.endsWith(".") ? newElementName : newElementName + ".";
                            newElementName = newPrefix + envVariableName;
                        }
                    }
                } else {
                    String prefix = antProperty.getPropertyPrefixValue();
                    if (prefix != null) {
                        newElementName = prefix + newElementName;
                    }
                }
            }
        }
        return super.handleElementRename(newElementName);
    }

    public boolean isReferenceTo(PsiElement element) {
        AntDomProperty prop;
        String propName;
        DomElement domElement = AntDomReferenceBase.toDomElement(element);
        if (domElement instanceof AntDomProperty && (propName = (prop = (AntDomProperty)domElement).getName().getRawText()) != null && prop.getPrefix().getRawText() == null && prop.getEnvironment().getRawText() == null && !propName.equalsIgnoreCase(this.getCanonicalText())) {
            return false;
        }
        return super.isReferenceTo(element);
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantResolver<AntDomPropertyReference> {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull AntDomPropertyReference antDomPropertyReference, boolean incompleteCode) {
            if (antDomPropertyReference == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/dom/AntDomPropertyReference$MyResolver", "resolve"));
            }
            ArrayList<MyResolveResult> result = new ArrayList<MyResolveResult>();
            AntDomProject project = (AntDomProject)antDomPropertyReference.myInvocationContextElement.getParentOfType(AntDomProject.class, true);
            if (project != null) {
                String propertyName;
                AntDomProject contextAntProject = project.getContextAntProject();
                Trinity<PsiElement, Collection<String>, PropertiesProvider> resolved = PropertyResolver.resolve(contextAntProject, propertyName = antDomPropertyReference.getCanonicalText(), antDomPropertyReference.myInvocationContextElement);
                PsiElement mainDeclaration = (PsiElement)resolved.getFirst();
                if (mainDeclaration != null) {
                    result.add(new MyResolveResult(mainDeclaration, (PropertiesProvider)resolved.getThird()));
                }
                List<PsiElement> antCallParams = AntCallParamsFinder.resolve(project, propertyName);
                for (PsiElement param : antCallParams) {
                    result.add(new MyResolveResult(param, null));
                }
            }
            ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.toArray(result, (Object[])new ResolveResult[result.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomPropertyReference$MyResolver", "resolve"));
            }
            return resolveResultArray;
        }
    }

    private static class MyResolveResult
    implements ResolveResult {
        private final PsiElement myElement;
        private final PropertiesProvider myProvider;

        public MyResolveResult(PsiElement element, PropertiesProvider provider) {
            this.myElement = element;
            this.myProvider = provider;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public PropertiesProvider getProvider() {
            return this.myProvider;
        }

        public boolean isValidResult() {
            return true;
        }
    }
}

