/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntDomAntCallParam;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AntCallParamsFinder
extends AntDomRecursiveVisitor {
    private final String myPropertyName;
    private final List<PsiElement> myResult;

    private AntCallParamsFinder(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/dom/AntCallParamsFinder", "<init>"));
        }
        this.myResult = new ArrayList<PsiElement>();
        this.myPropertyName = propertyName;
    }

    @Override
    public void visitAntDomElement(AntDomElement element) {
        if (!element.isDataType()) {
            super.visitAntDomElement(element);
        }
    }

    @Override
    public void visitAntDomAntCallParam(AntDomAntCallParam antCallParam) {
        PsiElement elem;
        if (this.myPropertyName.equals(antCallParam.getName().getStringValue()) && (elem = antCallParam.getNavigationElement(this.myPropertyName)) != null) {
            this.myResult.add(elem);
        }
    }

    @NotNull
    public static List<PsiElement> resolve(@NotNull AntDomProject project, @NotNull String propertyName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/dom/AntCallParamsFinder", "resolve"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/ant/dom/AntCallParamsFinder", "resolve"));
        }
        AntCallParamsFinder resolver = new AntCallParamsFinder(propertyName);
        project.accept(resolver);
        List<PsiElement> list = resolver.myResult;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntCallParamsFinder", "resolve"));
        }
        return list;
    }
}

