/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntTargetNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import icons.AntIcons;
import org.jetbrains.annotations.NotNull;

final class AntBuildFileNodeDescriptor
extends AntNodeDescriptor {
    private final AntBuildFileBase myBuildFile;
    private CompositeAppearance myAppearance;

    public AntBuildFileNodeDescriptor(Project project, NodeDescriptor parentDescriptor, AntBuildFileBase buildFile) {
        super(project, parentDescriptor);
        this.myBuildFile = buildFile;
    }

    public Object getElement() {
        return this.myBuildFile;
    }

    public AntBuildFile getBuildFile() {
        return this.myBuildFile;
    }

    public boolean update() {
        CompositeAppearance oldAppearance = this.myAppearance;
        this.myAppearance = new CompositeAppearance();
        this.myAppearance.getEnding().addText(this.myBuildFile.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        AntBuildModelBase buildModel = this.myBuildFile.getModelIfRegistered();
        if (buildModel != null) {
            AntTargetNodeDescriptor.addShortcutText(buildModel.getDefaultTargetActionId(), this.myAppearance);
        }
        this.myAppearance.setIcon(AntIcons.Build);
        this.myName = this.myBuildFile.getPresentableName();
        return !Comparing.equal((Object)this.myAppearance, (Object)oldAppearance);
    }

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/config/explorer/AntBuildFileNodeDescriptor", "customize"));
        }
        if (this.myAppearance != null) {
            this.myAppearance.customize(component);
        } else {
            super.customize(component);
        }
    }

    @Override
    public void customize(@NotNull HtmlListCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/config/explorer/AntBuildFileNodeDescriptor", "customize"));
        }
        if (this.myAppearance != null) {
            this.myAppearance.customize(renderer);
        } else {
            super.customize(renderer);
        }
    }

    @Override
    public boolean isAutoExpand() {
        return this.myBuildFile.shouldExpand();
    }
}

