/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.junit.JUnitProcessHandler;
import com.intellij.execution.junit2.segments.OutputPacketProcessor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.history.LocalHistory;
import com.intellij.ide.macro.Macro;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntCommandLineBuilder;
import com.intellij.lang.ant.config.execution.OutputParser;
import com.intellij.lang.ant.config.execution.OutputParser2;
import com.intellij.lang.ant.config.execution.RunCanceledException;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ant.execution.ExecutionHandler");
    @NonNls
    public static final String PARSER_JAR = "xerces1.jar";

    private ExecutionHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runBuild(final AntBuildFileBase buildFile, String[] targets, @Nullable AntBuildMessageView buildMessageViewToReuse, DataContext dataContext, List<BuildFileProperty> additionalProperties, final @NotNull AntBuildListener antBuildListener) {
        GeneralCommandLine commandLine;
        AntBuildMessageView messageView;
        AntCommandLineBuilder builder;
        if (antBuildListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/lang/ant/config/execution/ExecutionHandler", "runBuild"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        AntCommandLineBuilder antCommandLineBuilder = builder = new AntCommandLineBuilder();
        synchronized (antCommandLineBuilder) {
            Project project = buildFile.getProject();
            try {
                builder.setBuildFile(buildFile.getAllOptions(), VfsUtil.virtualToIoFile((VirtualFile)buildFile.getVirtualFile()));
                builder.calculateProperties(dataContext, additionalProperties);
                builder.addTargets(targets);
                builder.getCommandLine().setCharset(EncodingProjectManager.getInstance((Project)buildFile.getProject()).getDefaultCharset());
                messageView = ExecutionHandler.prepareMessageView(buildMessageViewToReuse, buildFile, targets);
                commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)builder.getCommandLine());
                messageView.setBuildCommandLine(commandLine.getCommandLineString());
            }
            catch (RunCanceledException e) {
                e.showMessage(project, AntBundle.message("run.ant.erorr.dialog.title", new Object[0]));
                antBuildListener.buildFinished(2, 0);
                return;
            }
            catch (CantRunException e) {
                ExecutionErrorDialog.show((ExecutionException)e, (String)AntBundle.message("cant.run.ant.erorr.dialog.title", new Object[0]), (Project)project);
                antBuildListener.buildFinished(2, 0);
                return;
            }
            catch (Macro.ExecutionCancelledException e) {
                antBuildListener.buildFinished(1, 0);
                return;
            }
            catch (Throwable e) {
                antBuildListener.buildFinished(2, 0);
                LOG.error(e);
                return;
            }
        }
        new Task.Backgroundable(buildFile.getProject(), AntBundle.message("ant.build.progress.dialog.title", new Object[0]), true){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void onCancel() {
                antBuildListener.buildFinished(1, 0);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/ant/config/execution/ExecutionHandler$1", "run"));
                }
                try {
                    ExecutionHandler.runBuild(indicator, messageView, buildFile, antBuildListener, commandLine);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    antBuildListener.buildFinished(2, 0);
                }
            }
        }.queue();
    }

    private static void runBuild(ProgressIndicator progress, @NotNull AntBuildMessageView errorView, @NotNull AntBuildFileBase buildFile, @NotNull AntBuildListener antBuildListener, @NotNull GeneralCommandLine commandLine) {
        JUnitProcessHandler handler;
        if (errorView == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/ant/config/execution/ExecutionHandler", "runBuild"));
        }
        if (buildFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/lang/ant/config/execution/ExecutionHandler", "runBuild"));
        }
        if (antBuildListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/lang/ant/config/execution/ExecutionHandler", "runBuild"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/lang/ant/config/execution/ExecutionHandler", "runBuild"));
        }
        final Project project = buildFile.getProject();
        long startTime = System.currentTimeMillis();
        LocalHistory.getInstance().putSystemLabel(project, AntBundle.message("ant.build.local.history.label", buildFile.getName()));
        try {
            handler = JUnitProcessHandler.runCommandLine((GeneralCommandLine)commandLine);
        }
        catch (ExecutionException e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExecutionErrorDialog.show((ExecutionException)e, (String)AntBundle.message("could.not.start.process.erorr.dialog.title", new Object[0]), (Project)project);
                }
            });
            antBuildListener.buildFinished(2, 0);
            return;
        }
        ExecutionHandler.processRunningAnt(progress, handler, errorView, buildFile, startTime, antBuildListener);
        handler.waitFor();
    }

    private static void processRunningAnt(final ProgressIndicator progress, final JUnitProcessHandler handler, final AntBuildMessageView errorView, AntBuildFileBase buildFile, final long startTime, final AntBuildListener antBuildListener) {
        Project project = buildFile.getProject();
        StatusBar statusbar = WindowManager.getInstance().getStatusBar(project);
        if (statusbar != null) {
            statusbar.setInfo(AntBundle.message("ant.build.started.status.message", new Object[0]));
        }
        final CheckCancelTask checkCancelTask = new CheckCancelTask(progress, (OSProcessHandler)handler);
        checkCancelTask.start(0L);
        final OutputParser parser = OutputParser2.attachParser(project, handler, errorView, progress, buildFile);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private final StringBuilder myUnprocessedStdErr = new StringBuilder();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDERR) {
                    String text = event.getText();
                    StringBuilder stringBuilder = this.myUnprocessedStdErr;
                    synchronized (stringBuilder) {
                        this.myUnprocessedStdErr.append(text);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(ProcessEvent event) {
                long buildTime = System.currentTimeMillis() - startTime;
                checkCancelTask.cancel();
                parser.setStopped(true);
                OutputPacketProcessor dispatcher = handler.getErr().getEventsDispatcher();
                if (event.getExitCode() != 0) {
                    String unprocessed;
                    StringBuilder stringBuilder = this.myUnprocessedStdErr;
                    synchronized (stringBuilder) {
                        unprocessed = this.myUnprocessedStdErr.toString();
                        this.myUnprocessedStdErr.setLength(0);
                    }
                    if (!unprocessed.isEmpty()) {
                        dispatcher.processOutput(new Printable(){

                            public void printOn(Printer printer) {
                                errorView.outputError(unprocessed, 0);
                            }
                        });
                    }
                } else {
                    StringBuilder stringBuilder = this.myUnprocessedStdErr;
                    synchronized (stringBuilder) {
                        this.myUnprocessedStdErr.setLength(0);
                    }
                }
                errorView.buildFinished(progress != null && progress.isCanceled(), buildTime, antBuildListener, dispatcher);
            }
        });
        handler.startNotify();
    }

    private static AntBuildMessageView prepareMessageView(@Nullable AntBuildMessageView buildMessageViewToReuse, AntBuildFileBase buildFile, String[] targets) throws RunCanceledException {
        AntBuildMessageView messageView;
        if (buildMessageViewToReuse != null) {
            messageView = buildMessageViewToReuse;
            messageView.emptyAll();
        } else {
            messageView = AntBuildMessageView.openBuildMessageView(buildFile.getProject(), buildFile, targets);
            if (messageView == null) {
                throw new RunCanceledException(AntBundle.message("canceled.by.user.error.message", new Object[0]));
            }
        }
        return messageView;
    }

    static final class CheckCancelTask
    implements Runnable {
        private final ProgressIndicator myProgressIndicator;
        private final OSProcessHandler myProcessHandler;
        private volatile boolean myCanceled;

        public CheckCancelTask(ProgressIndicator progressIndicator, OSProcessHandler process) {
            this.myProgressIndicator = progressIndicator;
            this.myProcessHandler = process;
        }

        public void cancel() {
            this.myCanceled = true;
        }

        @Override
        public void run() {
            if (!this.myCanceled) {
                try {
                    this.myProgressIndicator.checkCanceled();
                    this.start(50L);
                }
                catch (ProcessCanceledException e) {
                    this.myProcessHandler.destroyProcess();
                }
            }
        }

        public void start(long delay) {
            JobScheduler.getScheduler().schedule(this, delay, TimeUnit.MILLISECONDS);
        }
    }
}

