/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.whitelist;

import com.btr.proxy.selector.whitelist.HostnameFilter;
import com.btr.proxy.selector.whitelist.IpRangeFilter;
import com.btr.proxy.selector.whitelist.WhiteListParser;
import com.btr.proxy.util.UriFilter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWhiteListParser
implements WhiteListParser {
    @Override
    public List<UriFilter> parseWhiteList(String whiteList) {
        ArrayList<UriFilter> result = new ArrayList<UriFilter>();
        String[] token = whiteList.split("[, ]+");
        for (int i = 0; i < token.length; ++i) {
            token[i] = token[i].trim();
            if (token[i].contains("/")) {
                result.add(new IpRangeFilter(token[i]));
                continue;
            }
            if (token[i].endsWith("*")) {
                token[i] = token[i].substring(0, token[i].length() - 1);
                result.add(new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, token[i]));
                continue;
            }
            if (token[i].trim().startsWith("*")) {
                token[i] = token[i].substring(1);
                result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, token[i]));
                continue;
            }
            result.add(new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, token[i]));
        }
        return result;
    }
}

