/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest.api20alpha1;

import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.rest.JiraRestTask;
import com.intellij.tasks.jira.rest.api20alpha1.model.JiraIssueApi20Alpha1;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.tasks.jira.rest.model.JiraResponseWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraRestApi20Alpha1
extends JiraRestApi {
    private static final Logger LOG = Logger.getInstance(JiraRestApi20Alpha1.class);
    private static final Type ISSUES_WRAPPER_TYPE = new TypeToken<JiraResponseWrapper.Issues<JiraIssueApi20Alpha1>>(){}.getType();

    public JiraRestApi20Alpha1(JiraRepository repository) {
        super(repository);
    }

    @Override
    protected JiraIssue parseIssue(String response) {
        return (JiraIssue)JiraRepository.GSON.fromJson(response, JiraIssueApi20Alpha1.class);
    }

    @Override
    @NotNull
    protected List<JiraIssue> parseIssues(String response) {
        JiraResponseWrapper.Issues wrapper = (JiraResponseWrapper.Issues)JiraRepository.GSON.fromJson(response, ISSUES_WRAPPER_TYPE);
        List incompleteIssues = wrapper.getIssues();
        ArrayList<JiraIssue> updatedIssues = new ArrayList<JiraIssue>();
        for (JiraIssueApi20Alpha1 issue : incompleteIssues) {
            try {
                JiraRestTask task = this.findTask(issue.getKey());
                if (task == null) continue;
                updatedIssues.add(task.getJiraIssue());
            }
            catch (Exception e) {
                LOG.warn("Can't fetch detailed info about issue: " + issue.getKey());
            }
        }
        ArrayList<JiraIssue> arrayList = updatedIssues;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/api20alpha1/JiraRestApi20Alpha1", "parseIssues"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected String getRequestForStateTransition(@NotNull TaskState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/rest/api20alpha1/JiraRestApi20Alpha1", "getRequestForStateTransition"));
        }
        switch (state) {
            case IN_PROGRESS: {
                return "{\"transition\": \"4\"}";
            }
            case RESOLVED: {
                return "{\"transition\": \"5\", \"resolution\": \"Fixed\"}";
            }
            case REOPENED: {
                return "{\"transition\": \"3\"}";
            }
        }
        return null;
    }

    @Override
    public void updateTimeSpend(LocalTask task, String timeSpent, String comment) throws Exception {
        throw new Exception(TaskBundle.message((String)"jira.failure.no.state.update", (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public JiraRemoteApi.ApiType getType() {
        JiraRemoteApi.ApiType apiType = JiraRemoteApi.ApiType.REST_2_0_ALPHA;
        if (apiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/api20alpha1/JiraRestApi20Alpha1", "getType"));
        }
        return apiType;
    }
}

