/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.tasks.jira.jql.JqlLanguage;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JqlElementType
extends IElementType {
    private static final Class<?>[] PARAMETER_TYPES = new Class[]{ASTNode.class};
    private final Class<? extends PsiElement> myClass;
    private Constructor<? extends PsiElement> myConstructor;

    public JqlElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/jql/JqlElementType", "<init>"));
        }
        this(debugName, ASTWrapperPsiElement.class);
    }

    public JqlElementType(@NotNull @NonNls String debugName, @NotNull Class<? extends PsiElement> cls) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/jql/JqlElementType", "<init>"));
        }
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/jira/jql/JqlElementType", "<init>"));
        }
        super(debugName, (Language)JqlLanguage.INSTANCE);
        this.myClass = cls;
    }

    public String toString() {
        return "JQL: " + super.toString();
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        PsiElement psiElement;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/jql/JqlElementType", "createElement"));
        }
        try {
            if (this.myConstructor == null) {
                this.myConstructor = this.myClass.getConstructor(PARAMETER_TYPES);
            }
            psiElement = this.myConstructor.newInstance(node);
        }
        catch (Exception e) {
            throw new AssertionError((Object)String.format("Class %s must have constructor accepting single ASTNode parameter", this.myClass.getName()));
        }
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/JqlElementType", "createElement"));
        }
        return psiElement;
    }
}

