/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepositoryType;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.soap.JiraSoapApi;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="JIRA")
public class JiraRepository
extends BaseRepositoryImpl {
    public static final Gson GSON = TaskUtil.installDateDeserializer((GsonBuilder)new GsonBuilder()).create();
    private static final Logger LOG = Logger.getInstance(JiraRepository.class);
    public static final String REST_API_PATH = "/rest/api/latest";
    private static final boolean LEGACY_API_ONLY = Boolean.getBoolean("tasks.jira.legacy.api.only");
    private static final boolean BASIC_AUTH_ONLY = Boolean.getBoolean("tasks.jira.basic.auth.only");
    private static final boolean REDISCOVER_API = Boolean.getBoolean("tasks.jira.rediscover.api");
    private String mySearchQuery = TaskBundle.message((String)"jira.default.query", (Object[])new Object[0]);
    private JiraRemoteApi myApiVersion;

    public JiraRepository() {
        this.setUseHttpAuthentication(true);
    }

    public JiraRepository(JiraRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUseHttpAuthentication(true);
    }

    private JiraRepository(JiraRepository other) {
        super((BaseRepositoryImpl)other);
        this.mySearchQuery = other.mySearchQuery;
        if (other.myApiVersion != null) {
            this.myApiVersion = other.myApiVersion.getType().createApi(this);
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return Comparing.equal((String)this.mySearchQuery, (String)((JiraRepository)((Object)o)).mySearchQuery);
    }

    @NotNull
    public JiraRepository clone() {
        JiraRepository jiraRepository = new JiraRepository(this);
        if (jiraRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "clone"));
        }
        return jiraRepository;
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        this.ensureApiVersionDiscovered();
        String resultQuery = query;
        if (this.isJqlSupported()) {
            resultQuery = StringUtil.isNotEmpty((String)this.mySearchQuery) && StringUtil.isNotEmpty((String)query) ? String.format("summary ~ '%s' and ", query) + this.mySearchQuery : (StringUtil.isNotEmpty((String)query) ? String.format("summary ~ '%s'", query) : this.mySearchQuery);
        }
        return (Task[])ArrayUtil.toObjectArray(this.myApiVersion.findTasks(resultQuery, max), Task.class);
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/JiraRepository", "findTask"));
        }
        this.ensureApiVersionDiscovered();
        return this.myApiVersion.findTask(id);
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/JiraRepository", "updateTimeSpent"));
        }
        if (timeSpent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/jira/JiraRepository", "updateTimeSpent"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/tasks/jira/JiraRepository", "updateTimeSpent"));
        }
        this.myApiVersion.updateTimeSpend(task, timeSpent, comment);
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){

            protected void doTest() throws Exception {
                JiraRepository.this.ensureApiVersionDiscovered();
                JiraRepository.this.myApiVersion.findTasks("", 1);
            }

            public void cancel() {
            }
        };
    }

    @NotNull
    public JiraRemoteApi discoverApiVersion() throws Exception {
        String responseBody;
        if (LEGACY_API_ONLY) {
            LOG.info("Intentionally using only legacy JIRA API");
            JiraSoapApi jiraSoapApi = new JiraSoapApi(this);
            if (jiraSoapApi == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "discoverApiVersion"));
            }
            return jiraSoapApi;
        }
        GetMethod method = new GetMethod(this.getRestUrl("serverInfo"));
        try {
            responseBody = this.executeMethod((HttpMethod)method);
        }
        catch (Exception e) {
            if (method.hasBeenUsed() && method.getStatusCode() == 404) {
                JiraSoapApi jiraSoapApi = new JiraSoapApi(this);
                if (jiraSoapApi == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "discoverApiVersion"));
                }
                return jiraSoapApi;
            }
            throw e;
        }
        JsonObject object = (JsonObject)GSON.fromJson(responseBody, JsonObject.class);
        JiraRestApi restApi = JiraRestApi.fromJiraVersion(object.get("version").getAsString(), this);
        if (restApi == null) {
            throw new Exception(TaskBundle.message((String)"jira.failure.no.REST", (Object[])new Object[0]));
        }
        JiraRestApi jiraRestApi = restApi;
        if (jiraRestApi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "discoverApiVersion"));
        }
        return jiraRestApi;
    }

    private void ensureApiVersionDiscovered() throws Exception {
        if (this.myApiVersion == null || LEGACY_API_ONLY || REDISCOVER_API) {
            this.myApiVersion = this.discoverApiVersion();
        }
    }

    @NotNull
    public String executeMethod(@NotNull HttpMethod method) throws Exception {
        JsonObject object;
        Header header;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/JiraRepository", "executeMethod"));
        }
        LOG.debug("URI: " + method.getURI());
        HttpClient client = this.getHttpClient();
        if (BASIC_AUTH_ONLY) {
            this.setUseHttpAuthentication(true);
        } else {
            boolean enableBasicAuthentication;
            boolean cookieAuthenticated = false;
            for (Cookie cookie : client.getState().getCookies()) {
                if (!cookie.getName().equals("JSESSIONID") || cookie.isExpired()) continue;
                cookieAuthenticated = true;
                break;
            }
            boolean bl = enableBasicAuthentication = !this.isRestApiSupported() || !cookieAuthenticated;
            if (enableBasicAuthentication != this.isUseHttpAuthentication()) {
                LOG.info("Basic authentication for subsequent requests was " + (enableBasicAuthentication ? "enabled" : "disabled"));
            }
            this.setUseHttpAuthentication(enableBasicAuthentication);
        }
        int statusCode = client.executeMethod(method);
        LOG.debug("Status code: " + statusCode);
        InputStream stream = method.getResponseBodyAsStream();
        String entityContent = stream == null ? "" : StreamUtil.readText((InputStream)stream, (String)"UTF-8");
        TaskUtil.prettyFormatJsonToLog((Logger)LOG, (String)entityContent);
        if (statusCode >= 200 && statusCode < 300) {
            String string = entityContent;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraRepository", "executeMethod"));
            }
            return string;
        }
        if (method.getResponseHeader("Content-Type") != null && (header = method.getResponseHeader("Content-Type")).getValue().startsWith("application/json") && (object = (JsonObject)GSON.fromJson(entityContent, JsonObject.class)).has("errorMessages")) {
            String reason = StringUtil.join((Iterable)object.getAsJsonArray("errorMessages"), (String)" ");
            LOG.warn(reason);
            throw new Exception(TaskBundle.message((String)"failure.server.message", (Object[])new Object[]{reason}));
        }
        if (method.getResponseHeader("X-Authentication-Denied-Reason") != null && (header = method.getResponseHeader("X-Authentication-Denied-Reason")).getValue().startsWith("CAPTCHA_CHALLENGE")) {
            throw new Exception(TaskBundle.message((String)"jira.failure.captcha", (Object[])new Object[0]));
        }
        if (statusCode == 401) {
            throw new Exception(TaskBundle.message((String)"failure.login", (Object[])new Object[0]));
        }
        String statusText = HttpStatus.getStatusText((int)method.getStatusCode());
        throw new Exception(TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{statusCode, statusText}));
    }

    public HttpClient getHttpClient() {
        return super.getHttpClient();
    }

    protected void configureHttpClient(HttpClient client) {
        super.configureHttpClient(client);
        client.getParams().setCookiePolicy("compatibility");
    }

    protected int getFeatures() {
        int features = super.getFeatures();
        if (this.isRestApiSupported()) {
            return features | 4 | 8;
        }
        return features & 0xFFFFFFEF & 0xFFFFFFF7 & 0xFFFFFFFB;
    }

    private boolean isRestApiSupported() {
        return this.myApiVersion != null && this.myApiVersion.getType() != JiraRemoteApi.ApiType.SOAP;
    }

    public boolean isJqlSupported() {
        return this.isRestApiSupported();
    }

    public String getSearchQuery() {
        return this.mySearchQuery;
    }

    public void setTaskState(@NotNull Task task, @NotNull TaskState state) throws Exception {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/JiraRepository", "setTaskState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/tasks/jira/JiraRepository", "setTaskState"));
        }
        this.myApiVersion.setTaskState(task, state);
    }

    public void setSearchQuery(String searchQuery) {
        this.mySearchQuery = searchQuery;
    }

    public void setUrl(String url) {
        if (!this.getUrl().equals(url)) {
            this.myApiVersion = null;
            super.setUrl(url);
        }
    }

    @Nullable
    public JiraRemoteApi.ApiType getApiType() {
        return this.myApiVersion == null ? null : this.myApiVersion.getType();
    }

    public void setApiType(@Nullable JiraRemoteApi.ApiType type) {
        if (type != null) {
            this.myApiVersion = type.createApi(this);
        }
    }

    public String getRestUrl(String ... parts) {
        return this.getUrl() + REST_API_PATH + "/" + StringUtil.join((String[])parts, (String)"/");
    }
}

