/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.builder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkProperties;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkType;
import org.jetbrains.jps.devkit.model.JpsPluginModuleProperties;
import org.jetbrains.jps.devkit.model.JpsPluginModuleType;
import org.jetbrains.jps.incremental.artifacts.JpsSyntheticArtifactProvider;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.artifact.DirectoryArtifactType;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsPluginSyntheticArtifactProvider
extends JpsSyntheticArtifactProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.devkit.builder.JpsPluginSyntheticArtifactProvider");

    @NotNull
    public List<JpsArtifact> createArtifacts(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/jps/devkit/builder/JpsPluginSyntheticArtifactProvider", "createArtifacts"));
        }
        ArrayList<JpsArtifact> artifacts = new ArrayList<JpsArtifact>();
        for (JpsTypedModule module : model.getProject().getModules((JpsModuleType)JpsPluginModuleType.INSTANCE)) {
            artifacts.add(JpsPluginSyntheticArtifactProvider.createArtifact((JpsModule)module, (JpsPluginModuleProperties)((JpsSimpleElement)module.getProperties()).getData()));
        }
        ArrayList<JpsArtifact> arrayList = artifacts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/devkit/builder/JpsPluginSyntheticArtifactProvider", "createArtifacts"));
        }
        return arrayList;
    }

    private static JpsArtifact createArtifact(JpsModule module, JpsPluginModuleProperties properties) {
        String sandboxHome;
        JpsPackagingElementFactory factory = JpsPackagingElementFactory.getInstance();
        JpsArtifactRootElement root = factory.createArtifactRoot();
        String pluginXmlUrl = properties.getPluginXmlUrl();
        if (pluginXmlUrl != null) {
            String pluginXmlPath = JpsPathUtil.urlToPath((String)pluginXmlUrl);
            JpsCompositePackagingElement metaInfDir = factory.getOrCreateDirectory((JpsCompositePackagingElement)root, "META-INF");
            metaInfDir.addChild((JpsPackagingElement)factory.createFileCopy(pluginXmlPath, null));
            File pluginXmlFile = JpsPathUtil.urlToFile((String)pluginXmlUrl);
            if (pluginXmlFile.exists()) {
                try {
                    Element rootElement = JDOMUtil.loadDocument((File)pluginXmlFile).getRootElement();
                    for (Element dependsElement : JDOMUtil.getChildren((Element)rootElement, (String)"depends")) {
                        String relativePath = dependsElement.getAttributeValue("config-file");
                        if (relativePath == null) continue;
                        File dependencyFile = new File(pluginXmlFile.getParent(), FileUtil.toSystemDependentName((String)relativePath));
                        String dependencyPath = FileUtil.toSystemIndependentName((String)dependencyFile.getAbsolutePath());
                        metaInfDir.addChild((JpsPackagingElement)factory.createFileCopy(dependencyPath, null));
                    }
                }
                catch (JDOMException e) {
                    LOG.info((Throwable)e);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).recursively().includedIn(JpsJavaClasspathKind.PRODUCTION_RUNTIME);
        JpsCompositePackagingElement classesDir = factory.getOrCreateDirectory((JpsCompositePackagingElement)root, "classes");
        for (JpsModule depModule : enumerator.getModules()) {
            if (!depModule.getModuleType().equals(JpsJavaModuleType.INSTANCE)) continue;
            classesDir.addChild((JpsPackagingElement)JpsJavaExtensionService.getInstance().createProductionModuleOutput(depModule.createReference()));
        }
        classesDir.addChild((JpsPackagingElement)JpsJavaExtensionService.getInstance().createProductionModuleOutput(module.createReference()));
        for (JpsLibrary library : enumerator.getLibraries()) {
            JpsCompositePackagingElement parent = JpsPluginSyntheticArtifactProvider.hasDirsOnly(library) ? classesDir : factory.getOrCreateDirectory((JpsCompositePackagingElement)root, "lib");
            parent.addChild((JpsPackagingElement)factory.createLibraryElement(library.createReference()));
        }
        String name = module.getName() + ":plugin";
        JpsArtifact artifact = JpsArtifactService.getInstance().createArtifact(name, (JpsCompositePackagingElement)root, (JpsArtifactType)DirectoryArtifactType.INSTANCE, (JpsElement)JpsElementFactory.getInstance().createDummyElement());
        JpsSdk sdk = module.getSdk((JpsSdkType)JpsIdeaSdkType.INSTANCE);
        if (sdk != null && (sandboxHome = ((JpsIdeaSdkProperties)((JpsSimpleElement)sdk.getSdkProperties()).getData()).getSandboxHome()) != null) {
            artifact.setOutputPath(sandboxHome + "/plugins/" + module.getName());
        }
        return artifact;
    }

    private static boolean hasDirsOnly(JpsLibrary library) {
        List files = library.getFiles(JpsOrderRootType.COMPILED);
        for (File file : files) {
            if (file.isDirectory()) continue;
            return false;
        }
        return true;
    }
}

