/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlPropertiesFile
implements PropertiesFile {
    private static final Key<CachedValue<PropertiesFile>> KEY = Key.create((String)"xml properties file");
    private final XmlFile myFile;
    private final SoftLazyValue<MultiMap<String, IProperty>> myPropertiesMap = new SoftLazyValue<MultiMap<String, IProperty>>(){

        @NotNull
        protected MultiMap<String, IProperty> compute() {
            XmlTag rootTag = XmlPropertiesFile.this.myFile.getRootTag();
            if (rootTag == null) {
                MultiMap multiMap = MultiMap.emptyInstance();
                if (multiMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile$1", "compute"));
                }
                return multiMap;
            }
            XmlTag[] entries = rootTag.findSubTags("entry");
            MultiMap map = new MultiMap();
            for (XmlTag entry : entries) {
                XmlProperty property = new XmlProperty(entry, XmlPropertiesFile.this);
                map.putValue((Object)property.getKey(), (Object)property);
            }
            MultiMap multiMap = map;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile$1", "compute"));
            }
            return multiMap;
        }
    };

    @Nullable
    public static PropertiesFile getPropertiesFile(PsiFile file) {
        return file instanceof XmlFile && file.getFileType() == XmlFileType.INSTANCE ? XmlPropertiesFile.getPropertiesFile((XmlFile)file) : null;
    }

    public static PropertiesFile getPropertiesFile(final XmlFile file) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        return (PropertiesFile)manager.getCachedValue((UserDataHolder)file, KEY, (CachedValueProvider)new CachedValueProvider<PropertiesFile>(){

            public CachedValueProvider.Result<PropertiesFile> compute() {
                XmlPropertiesFile value = XmlPropertiesIndex.isPropertiesFile(file) ? new XmlPropertiesFile(file) : null;
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{file});
            }
        }, false);
    }

    private XmlPropertiesFile(XmlFile file) {
        this.myFile = file;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "getContainingFile"));
        }
        return xmlFile;
    }

    @Override
    @NotNull
    public List<IProperty> getProperties() {
        ArrayList<IProperty> arrayList = new ArrayList<IProperty>(((MultiMap)this.myPropertiesMap.getValue()).values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "getProperties"));
        }
        return arrayList;
    }

    @Override
    public IProperty findPropertyByKey(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/xml/XmlPropertiesFile", "findPropertyByKey"));
        }
        Collection properties = ((MultiMap)this.myPropertiesMap.getValue()).get((Object)key);
        return properties.isEmpty() ? null : (IProperty)properties.iterator().next();
    }

    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/xml/XmlPropertiesFile", "findPropertiesByKey"));
        }
        ArrayList<IProperty> arrayList = new ArrayList<IProperty>(((MultiMap)this.myPropertiesMap.getValue()).get((Object)key));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "findPropertiesByKey"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = PropertiesUtil.getResourceBundle(this.getContainingFile());
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "getResourceBundle"));
        }
        return resourceBundle;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = PropertiesUtil.getLocale(this.getVirtualFile());
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "getLocale"));
        }
        return locale;
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/xml/XmlPropertiesFile", "addProperty"));
        }
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "addProperty"));
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull Property property, @Nullable Property anchor) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/xml/XmlPropertiesFile", "addPropertyAfter"));
        }
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "addPropertyAfter"));
        }
        return null;
    }

    @Override
    public IProperty addProperty(String key, String value) {
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = rootTag.createChildTag("entry", "", value, false);
        entry.setAttribute("key", key);
        return new XmlProperty(entry, this);
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFile", "getNamesMap"));
        }
        return tHashMap;
    }

    @Override
    public String getName() {
        return this.getContainingFile().getName();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getContainingFile().getVirtualFile();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingFile().getParent();
    }

    @Override
    public Project getProject() {
        return this.getContainingFile().getProject();
    }

    @Override
    public String getText() {
        return this.getContainingFile().getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlPropertiesFile that = (XmlPropertiesFile)o;
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }
}

