/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyReferenceBase
implements PsiPolyVariantReference,
EmptyResolveMessageProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.references.PropertyReferenceBase");
    private static final LookupElementRenderer<LookupElement> LOOKUP_ELEMENT_RENDERER = new LookupElementRenderer<LookupElement>(){

        public void renderElement(LookupElement element, LookupElementPresentation presentation) {
            PropertiesFile defaultPropertiesFile;
            IProperty defaultProperty;
            boolean hasBundle;
            IProperty property = (IProperty)element.getObject();
            presentation.setIcon(PlatformIcons.PROPERTY_ICON);
            String key = StringUtil.notNullize((String)property.getUnescapedKey());
            presentation.setItemText(key);
            PropertiesFile propertiesFile = property.getPropertiesFile();
            ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
            String value = property.getValue();
            boolean bl = hasBundle = resourceBundle != ResourceBundleImpl.NULL;
            if (hasBundle && (defaultProperty = (defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile(propertiesFile.getProject())).findPropertyByKey(key)) != null) {
                value = defaultProperty.getValue();
            }
            if (hasBundle) {
                presentation.setTypeText(resourceBundle.getBaseName(), AllIcons.FileTypes.Properties);
            }
            if (presentation instanceof RealLookupElementPresentation && value != null) {
                value = "=" + value;
                int limit = 1000;
                if (value.length() > limit || !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value, false)) {
                    if (value.length() > limit) {
                        value = value.substring(0, limit);
                    }
                    while (value.length() > 0 && !((RealLookupElementPresentation)presentation).hasEnoughSpaceFor(value + "...", false)) {
                        value = value.substring(0, value.length() - 1);
                    }
                    value = value + "...";
                }
            }
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
            presentation.setTailText(value, attrs.getForegroundColor());
        }
    };
    protected final String myKey;
    protected final PsiElement myElement;
    protected boolean mySoft;
    private final TextRange myTextRange;

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/references/PropertyReferenceBase", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/lang/properties/references/PropertyReferenceBase", "<init>"));
        }
        this(key, soft, element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public PropertyReferenceBase(@NotNull String key, boolean soft, @NotNull PsiElement element, TextRange range) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/references/PropertyReferenceBase", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/lang/properties/references/PropertyReferenceBase", "<init>"));
        }
        this.myKey = key;
        this.mySoft = soft;
        this.myElement = element;
        this.myTextRange = range;
    }

    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    protected String getKeyText() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/PropertyReferenceBase", "getKeyText"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyReferenceBase other = (PropertyReferenceBase)o;
        return this.getElement() == other.getElement() && this.getKeyText().equals(other.getKeyText());
    }

    public int hashCode() {
        return this.getKeyText().hashCode();
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/PropertyReferenceBase", "getElement"));
        }
        return psiElement;
    }

    public TextRange getRangeInElement() {
        return this.myTextRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/PropertyReferenceBase", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        if (manipulator == null) {
            LOG.error("Cannot find manipulator for " + this.myElement + " of class " + this.myElement.getClass());
        }
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/references/PropertyReferenceBase", "bindToElement"));
        }
        throw new IncorrectOperationException("not implemented");
    }

    public boolean isReferenceTo(PsiElement element) {
        for (ResolveResult result : this.multiResolve(false)) {
            PsiElement el = result.getElement();
            if (el == null || !el.isEquivalentTo(element)) continue;
            return true;
        }
        return false;
    }

    protected void addKey(Object property, Set<Object> variants) {
        variants.add(property);
    }

    protected void addVariantsFromFile(PropertiesFile propertiesFile, Set<Object> variants) {
        if (propertiesFile == null) {
            return;
        }
        if (!ProjectRootManager.getInstance((Project)this.myElement.getProject()).getFileIndex().isInContent(propertiesFile.getVirtualFile())) {
            return;
        }
        List<IProperty> properties = propertiesFile.getProperties();
        for (IProperty property : properties) {
            this.addKey(property, variants);
        }
    }

    protected void setSoft(boolean soft) {
        this.mySoft = soft;
    }

    public boolean isSoft() {
        return this.mySoft;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = PropertiesBundle.message("unresolved.property.key", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/PropertyReferenceBase", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ArrayList<IProperty> properties;
        String key = this.getKeyText();
        List<PropertiesFile> propertiesFiles = this.getPropertiesFiles();
        if (propertiesFiles == null) {
            properties = PropertiesUtil.findPropertiesByKey(this.getElement().getProject(), key);
        } else {
            properties = new ArrayList();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                properties.addAll(propertiesFile.findPropertiesByKey(key));
            }
        }
        ContainerUtil.quickSort(properties, (Comparator)new Comparator<IProperty>(){

            @Override
            public int compare(IProperty o1, IProperty o2) {
                String name1 = o1.getPropertiesFile().getName();
                String name2 = o2.getPropertiesFile().getName();
                return Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)name2));
            }
        });
        ResolveResult[] resolveResultArray = PropertyReferenceBase.getResolveResults(properties);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/PropertyReferenceBase", "multiResolve"));
        }
        return resolveResultArray;
    }

    protected static ResolveResult[] getResolveResults(List<IProperty> properties) {
        if (properties.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] results = new ResolveResult[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            IProperty property = properties.get(i);
            results[i] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
        }
        return results;
    }

    @Nullable
    protected abstract List<PropertiesFile> getPropertiesFiles();

    @NotNull
    public Object[] getVariants() {
        THashSet variants = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<Object>(){

            public int computeHashCode(Object object) {
                if (object instanceof IProperty) {
                    String key = ((IProperty)object).getKey();
                    return key == null ? 0 : key.hashCode();
                }
                return 0;
            }

            public boolean equals(Object o1, Object o2) {
                return o1 instanceof IProperty && o2 instanceof IProperty && Comparing.equal((String)((IProperty)o1).getKey(), (String)((IProperty)o2).getKey(), (boolean)true);
            }
        });
        List<PropertiesFile> propertiesFileList = this.getPropertiesFiles();
        if (propertiesFileList == null) {
            PropertiesReferenceManager.getInstance(this.myElement.getProject()).processAllPropertiesFiles(new PropertiesFileProcessor((Set)variants){
                final /* synthetic */ Set val$variants;
                {
                    this.val$variants = set;
                }

                @Override
                public boolean process(String baseName, PropertiesFile propertiesFile) {
                    PropertyReferenceBase.this.addVariantsFromFile(propertiesFile, this.val$variants);
                    return true;
                }
            });
        } else {
            for (PropertiesFile propFile : propertiesFileList) {
                this.addVariantsFromFile(propFile, (Set<Object>)variants);
            }
        }
        Object[] objectArray = PropertyReferenceBase.getVariants((Set<Object>)variants);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/references/PropertyReferenceBase", "getVariants"));
        }
        return objectArray;
    }

    protected static Object[] getVariants(Set<Object> variants) {
        return ContainerUtil.mapNotNull(variants, (Function)new NullableFunction<Object, LookupElement>(){

            public LookupElement fun(Object o) {
                if (o instanceof String) {
                    return LookupElementBuilder.create((String)((String)o)).withIcon(PlatformIcons.PROPERTY_ICON);
                }
                IProperty property = (IProperty)o;
                String key = property.getKey();
                if (key == null) {
                    return null;
                }
                return LookupElementBuilder.create((Object)property, (String)key).withRenderer(LOOKUP_ELEMENT_RENDERER);
            }
        }).toArray();
    }
}

