/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ResourceBundleRenameHandler.class.getName()));

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        ResourceBundle bundle = ResourceBundleUtil.getResourceBundleFromDataContext(dataContext);
        if (bundle == null) {
            return false;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        ResourceBundleEditor editor = ResourceBundleUtil.getEditor(dataContext);
        return !(editor != null && editor.getState(FileEditorStateLevel.NAVIGATION).getPropertyName() != null || bundle.getPropertiesFiles(project).size() <= 1 || !(virtualFile instanceof ResourceBundleAsVirtualFile) && virtualFile != null);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/refactoring/ResourceBundleRenameHandler", "invoke"));
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getResourceBundleFromDataContext(dataContext);
        assert (resourceBundle != null);
        Messages.showInputDialog((Project)project, (String)PropertiesBundle.message("rename.bundle.enter.new.resource.bundle.base.name.prompt.text", new Object[0]), (String)PropertiesBundle.message("rename.resource.bundle.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)resourceBundle.getBaseName(), (InputValidator)new MyInputValidator(project, resourceBundle));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/refactoring/ResourceBundleRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/refactoring/ResourceBundleRenameHandler", "invoke"));
        }
        this.invoke(project, null, null, dataContext);
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final ResourceBundle myResourceBundle;

        public MyInputValidator(Project project, ResourceBundle resourceBundle) {
            this.myProject = project;
            this.myResourceBundle = resourceBundle;
        }

        public boolean checkInput(String inputString) {
            return inputString.indexOf(File.separatorChar) < 0 && inputString.indexOf(47) < 0;
        }

        public boolean canClose(String inputString) {
            return this.doRename(inputString);
        }

        private boolean doRename(String inputString) {
            List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
            for (PropertiesFile propertiesFile : propertiesFiles) {
                if (FileModificationService.getInstance().prepareFileForWrite(propertiesFile.getContainingFile())) continue;
                return false;
            }
            RenameProcessor renameProcessor = null;
            String baseName = this.myResourceBundle.getBaseName();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                VirtualFile virtualFile = propertiesFile.getVirtualFile();
                if (virtualFile == null) continue;
                String newName = inputString + virtualFile.getNameWithoutExtension().substring(baseName.length()) + "." + virtualFile.getExtension();
                if (renameProcessor == null) {
                    renameProcessor = new RenameProcessor(this.myProject, (PsiElement)propertiesFile.getContainingFile(), newName, false, false);
                    continue;
                }
                renameProcessor.addElement((PsiElement)propertiesFile.getContainingFile(), newName);
            }
            if (renameProcessor == null) {
                LOG.assertTrue(false);
                return true;
            }
            renameProcessor.setCommandName(PropertiesBundle.message("rename.resource.bundle.dialog.title", new Object[0]));
            renameProcessor.doRun();
            return true;
        }
    }
}

