/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleKeyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        ResourceBundleEditor editor = ResourceBundleUtil.getEditor(dataContext);
        if (editor == null) {
            return false;
        }
        return editor.getState(FileEditorStateLevel.NAVIGATION).getPropertyName() != null;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/refactoring/ResourceBundleKeyRenameHandler", "invoke"));
        }
        ResourceBundleEditor bundleEditor = ResourceBundleUtil.getEditor(dataContext);
        if (bundleEditor == null) {
            return;
        }
        String propertyName = bundleEditor.getState(FileEditorStateLevel.NAVIGATION).getPropertyName();
        if (propertyName == null) {
            return;
        }
        ResourceBundle bundle = ResourceBundleUtil.getResourceBundleFromDataContext(dataContext);
        if (bundle == null) {
            return;
        }
        Messages.showInputDialog((Project)project, (String)PropertiesBundle.message("rename.bundle.enter.new.resource.bundle.key.name.prompt.text", new Object[0]), (String)PropertiesBundle.message("rename.resource.bundle.key.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)propertyName, (InputValidator)new ResourceBundleKeyRenameValidator(project, bundleEditor, bundle, propertyName));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/refactoring/ResourceBundleKeyRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/refactoring/ResourceBundleKeyRenameHandler", "invoke"));
        }
        this.invoke(project, null, null, dataContext);
    }

    private static class ResourceBundleKeyRenameValidator
    implements InputValidator {
        private final Set<String> myExistingProperties = new HashSet();
        private final ResourceBundleEditor myEditor;
        private final String myOldPropertyName;

        ResourceBundleKeyRenameValidator(Project project, ResourceBundleEditor editor, ResourceBundle bundle, String oldPropertyName) {
            this.myEditor = editor;
            this.myOldPropertyName = oldPropertyName;
            for (PropertiesFile file : bundle.getPropertiesFiles(project)) {
                for (IProperty property : file.getProperties()) {
                    this.myExistingProperties.add(property.getKey());
                }
            }
            this.myExistingProperties.remove(oldPropertyName);
        }

        public boolean checkInput(String inputString) {
            return inputString != null && !inputString.isEmpty() && !this.myExistingProperties.contains(inputString);
        }

        public boolean canClose(final String inputString) {
            if (!this.checkInput(inputString)) {
                return false;
            }
            if (this.myOldPropertyName.equals(inputString)) {
                return true;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ResourceBundleKeyRenameValidator.this.myEditor.renameProperty(ResourceBundleKeyRenameValidator.this.myOldPropertyName, inputString);
                }
            });
            return true;
        }
    }
}

