/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public class PropertyImplEscaper
extends LiteralTextEscaper<PropertyImpl> {
    private static final Logger LOG = Logger.getInstance(PropertyImplEscaper.class);
    private int[] outSourceOffsets;

    public PropertyImplEscaper(PropertyImpl value) {
        super((PsiLanguageInjectionHost)value);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/psi/impl/PropertyImplEscaper", "decode"));
        }
        if (outChars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/psi/impl/PropertyImplEscaper", "decode"));
        }
        TextRange.assertProperRange((Segment)rangeInsideHost);
        String subText = rangeInsideHost.substring(((PropertyImpl)this.myHost).getText());
        this.outSourceOffsets = new int[subText.length() + 1];
        int prefixLen = outChars.length();
        boolean b = PropertyImpl.parseCharacters(subText, outChars, this.outSourceOffsets);
        if (b) {
            int len = outChars.length();
            for (int i = prefixLen; i < len; ++i) {
                char inChar;
                char outChar = outChars.charAt(i);
                if (outChar == (inChar = subText.charAt(this.outSourceOffsets[i - prefixLen])) || inChar == '\\') continue;
                LOG.error("input: " + subText + ";\noutput: " + outChars + "\nat: " + i + "; prefix-length: " + prefixLen);
            }
        }
        return b;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        int result;
        if (rangeInsideHost == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/psi/impl/PropertyImplEscaper", "getOffsetInHost"));
        }
        int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
        if (result == -1) {
            return -1;
        }
        return (result <= rangeInsideHost.getLength() ? result : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return !((PropertyImpl)this.myHost).getText().contains("\\");
    }
}

