/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesFileImpl
extends PsiFileBase
implements PropertiesFile {
    private static final TokenSet PROPERTIES_LIST_SET = TokenSet.create((IElementType[])new IElementType[]{PropertiesElementTypes.PROPERTIES_LIST});
    private volatile MostlySingularMultiMap<String, IProperty> myPropertiesMap;
    private volatile List<IProperty> myProperties;
    private final Object lock = new Object();

    public PropertiesFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, (Language)PropertiesLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.PROPERTIES;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "getFileType"));
        }
        return languageFileType;
    }

    @NonNls
    public String toString() {
        return "Properties file:" + this.getName();
    }

    @Override
    @NotNull
    public List<IProperty> getProperties() {
        this.ensurePropertiesLoaded();
        List<IProperty> list = this.myProperties;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "getProperties"));
        }
        return list;
    }

    private ASTNode getPropertiesList() {
        return (ASTNode)ArrayUtil.getFirstElement((Object[])this.getNode().getChildren(PROPERTIES_LIST_SET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePropertiesLoaded() {
        if (this.myPropertiesMap != null) {
            return;
        }
        ASTNode[] props = this.getPropertiesList().getChildren(PropertiesElementTypes.PROPERTIES);
        MostlySingularMultiMap propertiesMap = new MostlySingularMultiMap();
        ArrayList<IProperty> properties = new ArrayList<IProperty>(props.length);
        for (ASTNode prop : props) {
            Property property = (Property)prop.getPsi();
            String key = property.getUnescapedKey();
            propertiesMap.add((Object)key, (Object)property);
            properties.add(property);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.myPropertiesMap != null) {
                return;
            }
            this.myProperties = properties;
            this.myPropertiesMap = propertiesMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProperty findPropertyByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "findPropertyByKey"));
        }
        this.ensurePropertiesLoaded();
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.myPropertiesMap.get((Object)key).iterator();
            return iterator.hasNext() ? (IProperty)iterator.next() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "findPropertiesByKey"));
        }
        this.ensurePropertiesLoaded();
        Object object = this.lock;
        // MONITORENTER : object
        List list = ContainerUtil.collect(this.myPropertiesMap.get((Object)key).iterator());
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "findPropertiesByKey"));
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = PropertiesUtil.getResourceBundle(this.getContainingFile());
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "getResourceBundle"));
        }
        return resourceBundle;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = PropertiesUtil.getLocale(this.getVirtualFile());
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "getLocale"));
        }
        return locale;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "add"));
        }
        if (element instanceof Property) {
            throw new IncorrectOperationException("Use addProperty() instead");
        }
        return super.add(element);
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "addProperty"));
        }
        if (this.haveToAddNewLine()) {
            this.insertLineBreakBefore(null);
        }
        TreeElement copy = ChangeUtil.copyToElement((PsiElement)property.getPsiElement());
        this.getPropertiesList().addChild((ASTNode)copy);
        PsiElement psiElement = copy.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "addProperty"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull Property property, @Nullable Property anchor) throws IncorrectOperationException {
        ASTNode anchorBefore;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "addPropertyAfter"));
        }
        TreeElement copy = ChangeUtil.copyToElement((PsiElement)property);
        List<IProperty> properties = this.getProperties();
        Object object = anchor == null ? (properties.isEmpty() ? null : properties.get(0).getPsiElement().getNode()) : (anchorBefore = anchor.getNode().getTreeNext());
        if (anchorBefore != null && anchorBefore.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorBefore.getTreeNext();
        }
        if (anchorBefore == null && this.haveToAddNewLine()) {
            this.insertLineBreakBefore(null);
        }
        this.getPropertiesList().addChild((ASTNode)copy, anchorBefore);
        if (anchorBefore != null) {
            this.insertLineBreakBefore(anchorBefore);
        }
        PsiElement psiElement = copy.getPsi();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "addPropertyAfter"));
        }
        return psiElement;
    }

    @Override
    public IProperty addProperty(String key, String value) {
        return (IProperty)this.addProperty(PropertiesElementFactory.createProperty(this.getProject(), key, value));
    }

    private void insertLineBreakBefore(ASTNode anchorBefore) {
        this.getPropertiesList().addChild((ASTNode)ASTFactory.whitespace((CharSequence)"\n"), anchorBefore);
    }

    private boolean haveToAddNewLine() {
        ASTNode lastChild = this.getPropertiesList().getLastChildNode();
        return lastChild != null && !lastChild.getText().endsWith("\n");
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/psi/impl/PropertiesFileImpl", "getNamesMap"));
        }
        return tHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        Object object = this.lock;
        synchronized (object) {
            this.myPropertiesMap = null;
            this.myProperties = null;
        }
    }
}

