/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ResourceBundleDeleteProvider
implements DeleteProvider {
    private static final Function<PropertiesFile, PsiElement> MAPPER = new Function<PropertiesFile, PsiElement>(){

        public PsiElement fun(PropertiesFile propertiesFile) {
            return propertiesFile.getContainingFile();
        }
    };
    private final ResourceBundle myResourceBundle;

    public ResourceBundleDeleteProvider(ResourceBundle resourceBundle) {
        this.myResourceBundle = resourceBundle;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/projectView/ResourceBundleDeleteProvider", "deleteElement"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(project);
        assert (project != null);
        new SafeDeleteHandler().invoke(project, (PsiElement[])ContainerUtil.map2Array(propertiesFiles, PsiElement.class, MAPPER), dataContext);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/projectView/ResourceBundleDeleteProvider", "canDeleteElement"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project != null;
    }
}

