/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.NoPropertySelectedPanel;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewComponent;
import com.intellij.lang.properties.editor.ResourceBundleUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleEditor
extends UserDataHolderBase
implements FileEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.editor.ResourceBundleEditor");
    @NonNls
    private static final String VALUES = "values";
    @NonNls
    private static final String NO_PROPERTY_SELECTED = "noPropertySelected";
    private final StructureViewComponent myStructureViewComponent;
    private final Map<PropertiesFile, Editor> myEditors;
    private final ResourceBundle myResourceBundle;
    private final Map<PropertiesFile, JPanel> myTitledPanels;
    private final JComponent myNoPropertySelectedPanel;
    private final Map<Editor, DocumentListener> myDocumentListeners;
    private final Project myProject;
    private final DataProviderPanel myDataProviderPanel;
    private final Set<PropertiesFile> myBackSlashPressed;
    private final Alarm myUpdateEditorAlarm;
    private final Alarm mySelectionChangeAlarm;
    private JPanel myPanel;
    private JPanel myValuesPanel;
    private JPanel myStructureViewPanel;
    private JPanel mySplitParent;
    private boolean myDisposed;
    private VirtualFileListener myVfsListener;
    private Editor mySelectedEditor;
    private final Alarm myUpdatePsiAlarm;

    public ResourceBundleEditor(Project project, ResourceBundle resourceBundle) {
        this.$$$setupUI$$$();
        this.myNoPropertySelectedPanel = new NoPropertySelectedPanel().getComponent();
        this.myDocumentListeners = new THashMap();
        this.myBackSlashPressed = new THashSet();
        this.myUpdateEditorAlarm = new Alarm();
        this.mySelectionChangeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myUpdatePsiAlarm = new Alarm();
        this.myProject = project;
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        this.myResourceBundle = resourceBundle;
        this.myStructureViewComponent = new ResourceBundleStructureViewComponent(project, this.myResourceBundle, this);
        this.myStructureViewPanel.setLayout(new BorderLayout());
        this.myStructureViewPanel.add((Component)this.myStructureViewComponent, "Center");
        this.myStructureViewComponent.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            private String selectedPropertyName;
            private PropertiesFile selectedPropertiesFile;

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ResourceBundleEditor.this.getSelectedPropertyName() == null) {
                    return;
                }
                if (!Comparing.strEqual((String)this.selectedPropertyName, (String)ResourceBundleEditor.this.getSelectedPropertyName()) || !Comparing.equal((Object)this.selectedPropertiesFile, (Object)ResourceBundleEditor.this.getSelectedPropertiesFile())) {
                    this.selectedPropertyName = ResourceBundleEditor.this.getSelectedPropertyName();
                    this.selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    ResourceBundleEditor.this.selectionChanged();
                }
            }
        });
        this.installPropertiesChangeListeners();
        this.myEditors = new THashMap();
        this.myTitledPanels = new THashMap();
        this.recreateEditorsPanel();
        TreeElement[] children = this.myStructureViewComponent.getTreeModel().getRoot().getChildren();
        if (children.length != 0) {
            TreeElement child = children[0];
            String propName = ((ResourceBundlePropertyStructureViewElement)child).getValue();
            this.setState(new ResourceBundleEditorState(propName));
        }
        this.myDataProviderPanel = new DataProviderPanel(this.myPanel);
        this.getSplitter().setAndLoadSplitterProportionKey(((Object)((Object)this)).getClass() + ".splitter");
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$2", "selectionChanged"));
                }
                ResourceBundleEditor.this.onSelectionChanged(event);
            }
        });
    }

    private void onSelectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "onSelectionChanged"));
        }
        FileEditor oldEditor = event.getOldEditor();
        FileEditor newEditor = event.getNewEditor();
        if (oldEditor != this && newEditor != this) {
            return;
        }
        if (newEditor == this) {
            if (oldEditor instanceof TextEditor) {
                this.setStructureViewSelectionFromPropertiesFile(((TextEditor)oldEditor).getEditor());
            }
        } else if (newEditor instanceof TextEditor) {
            this.setPropertiesFileSelectionFromStructureView(((TextEditor)newEditor).getEditor());
        }
    }

    private void setStructureViewSelectionFromPropertiesFile(@NotNull Editor propertiesFileEditor) {
        if (propertiesFileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setStructureViewSelectionFromPropertiesFile"));
        }
        int line = propertiesFileEditor.getCaretModel().getLogicalPosition().line;
        Document document = propertiesFileEditor.getDocument();
        if (line >= document.getLineCount()) {
            return;
        }
        String propertyName = ResourceBundleEditor.getPropertyName(document, line);
        if (propertyName == null) {
            return;
        }
        this.setStructureViewSelection(propertyName);
    }

    private void setStructureViewSelection(final @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setStructureViewSelection"));
        }
        JTree tree = this.myStructureViewComponent.getTree();
        if (tree == null) {
            return;
        }
        Object root = tree.getModel().getRoot();
        if (AbstractTreeUi.isLoadingChildrenFor((Object)root)) {
            this.mySelectionChangeAlarm.cancelAllRequests();
            this.mySelectionChangeAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ResourceBundleEditor.this.mySelectionChangeAlarm.cancelAllRequests();
                    ResourceBundleEditor.this.setStructureViewSelection(propertyName);
                }
            }, 500);
            return;
        }
        Stack toCheck = ContainerUtilRt.newStack();
        toCheck.push((Object)((DefaultMutableTreeNode)root));
        DefaultMutableTreeNode nodeToSelect = null;
        while (!toCheck.isEmpty()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)toCheck.pop();
            String value = ResourceBundleEditor.getNodeValue(node);
            if (propertyName.equals(value)) {
                nodeToSelect = node;
                break;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                toCheck.push((Object)((DefaultMutableTreeNode)node.getChildAt(i)));
            }
        }
        if (nodeToSelect != null) {
            TreePath path = new TreePath(nodeToSelect.getPath());
            tree.setSelectionPath(path);
            tree.scrollPathToVisible(path);
        }
    }

    @Nullable
    private static String getPropertyName(@NotNull Document document, int line) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getPropertyName"));
        }
        int startOffset = document.getLineStartOffset(line);
        int endOffset = StringUtil.indexOf((CharSequence)document.getCharsSequence(), (char)'=', (int)startOffset, (int)document.getLineEndOffset(line));
        if (endOffset <= startOffset) {
            return null;
        }
        String propertyName = ((Object)document.getCharsSequence().subSequence(startOffset, endOffset)).toString().trim();
        return propertyName.isEmpty() ? null : propertyName;
    }

    private void setPropertiesFileSelectionFromStructureView(@NotNull Editor propertiesFileEditor) {
        if (propertiesFileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setPropertiesFileSelectionFromStructureView"));
        }
        String selectedPropertyName = this.getSelectedPropertyName();
        if (selectedPropertyName == null) {
            return;
        }
        Document document = propertiesFileEditor.getDocument();
        for (int i = 0; i < document.getLineCount(); ++i) {
            String propertyName = ResourceBundleEditor.getPropertyName(document, i);
            if (!selectedPropertyName.equals(propertyName)) continue;
            propertiesFileEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, 0));
            return;
        }
    }

    @Nullable
    private static String getNodeValue(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getNodeValue"));
        }
        Object userObject = node.getUserObject();
        if (!(userObject instanceof AbstractTreeNode)) {
            return null;
        }
        Object value = ((AbstractTreeNode)userObject).getValue();
        return value instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)value).getValue() : null;
    }

    private void recreateEditorsPanel() {
        this.myUpdateEditorAlarm.cancelAllRequests();
        this.myValuesPanel.removeAll();
        this.myValuesPanel.setLayout(new CardLayout());
        if (!this.myProject.isOpen()) {
            return;
        }
        MyJPanel valuesPanelComponent = new MyJPanel(new GridBagLayout());
        this.myValuesPanel.add((Component)new JBScrollPane(valuesPanelComponent){

            public void updateUI() {
                super.updateUI();
                this.getViewport().setBackground(UIUtil.getPanelBackground());
            }
        }, VALUES);
        this.myValuesPanel.add((Component)this.myNoPropertySelectedPanel, NO_PROPERTY_SELECTED);
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        this.releaseAllEditors();
        this.myTitledPanels.clear();
        int y = 0;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            Editor editor;
            Editor oldEditor = this.myEditors.put(propertiesFile, editor = ResourceBundleEditor.createEditor());
            if (oldEditor != null) {
                EditorFactory.getInstance().releaseEditor(oldEditor);
            }
            editor.getContentComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ResourceBundleEditor.this.mySelectedEditor = editor;
                }
            });
            gc.gridx = 0;
            gc.gridy = y++;
            gc.gridheight = 1;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.anchor = 10;
            Locale locale = propertiesFile.getLocale();
            ArrayList<String> names = new ArrayList<String>();
            if (!Comparing.strEqual((String)locale.getDisplayLanguage(), null)) {
                names.add(locale.getDisplayLanguage());
            }
            if (!Comparing.strEqual((String)locale.getDisplayCountry(), null)) {
                names.add(locale.getDisplayCountry());
            }
            if (!Comparing.strEqual((String)locale.getDisplayVariant(), null)) {
                names.add(locale.getDisplayVariant());
            }
            String title = propertiesFile.getName();
            if (!names.isEmpty()) {
                title = title + " (" + StringUtil.join(names, (String)"/") + ")";
            }
            JPanel comp = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Insets insets = this.getBorder().getBorderInsets(this);
                    return new Dimension(100, editor.getLineHeight() * 4 + insets.top + insets.bottom);
                }
            };
            comp.add((Component)editor.getComponent(), "Center");
            comp.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)true));
            this.myTitledPanels.put(propertiesFile, comp);
            valuesPanelComponent.add((Component)comp, gc);
        }
        gc.gridx = 0;
        gc.gridy = y;
        gc.gridheight = 0;
        gc.gridwidth = 0;
        gc.weightx = 10.0;
        gc.weighty = 1.0;
        valuesPanelComponent.add((Component)new JPanel(), gc);
        this.myValuesPanel.repaint();
    }

    private void installPropertiesChangeListeners() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (this.myVfsListener != null) {
            assert (false);
            virtualFileManager.removeVirtualFileListener(this.myVfsListener);
        }
        this.myVfsListener = new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$7", "fileCreated"));
                }
                if (PropertiesUtil.isPropertiesFile(event.getFile(), ResourceBundleEditor.this.myProject)) {
                    ResourceBundleEditor.this.recreateEditorsPanel();
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$7", "fileDeleted"));
                }
                for (PropertiesFile file : ResourceBundleEditor.this.myEditors.keySet()) {
                    if (!Comparing.equal((Object)file.getVirtualFile(), (Object)event.getFile())) continue;
                    ResourceBundleEditor.this.recreateEditorsPanel();
                    return;
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$7", "propertyChanged"));
                }
                if (PropertiesUtil.isPropertiesFile(event.getFile(), ResourceBundleEditor.this.myProject)) {
                    if ("name".equals(event.getPropertyName())) {
                        ResourceBundleEditor.this.recreateEditorsPanel();
                    } else {
                        ResourceBundleEditor.this.updateEditorsFromProperties();
                    }
                }
            }
        };
        virtualFileManager.addVirtualFileListener(this.myVfsListener, (Disposable)this);
        PsiTreeChangeAdapter psiTreeChangeAdapter = new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$8", "childAdded"));
                }
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$8", "childRemoved"));
                }
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$8", "childReplaced"));
                }
                this.childrenChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$8", "childMoved"));
                }
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor$8", "childrenChanged"));
                }
                PsiFile file = event.getFile();
                PropertiesFile propertiesFile = PropertiesUtil.getPropertiesFile(file);
                if (propertiesFile == null) {
                    return;
                }
                if (!propertiesFile.getResourceBundle().equals(ResourceBundleEditor.this.myResourceBundle)) {
                    return;
                }
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeAdapter, (Disposable)this);
    }

    private void selectionChanged() {
        this.myBackSlashPressed.clear();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ResourceBundleEditor.this.updateEditorsFromProperties();
            }
        });
    }

    private void updateEditorsFromProperties() {
        this.myUpdateEditorAlarm.cancelAllRequests();
        this.myUpdateEditorAlarm.addRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!ResourceBundleEditor.this.isValid()) {
                    return;
                }
                if (!ResourceBundleEditor.this.myUpdatePsiAlarm.isEmpty()) {
                    ResourceBundleEditor.this.myUpdateEditorAlarm.cancelAllRequests();
                    ResourceBundleEditor.this.myUpdateEditorAlarm.addRequest((Runnable)this, 200);
                    return;
                }
                ResourceBundleEditor.this.uninstallDocumentListeners();
                try {
                    String propertyName = ResourceBundleEditor.this.getSelectedPropertyName();
                    ((CardLayout)ResourceBundleEditor.this.myValuesPanel.getLayout()).show(ResourceBundleEditor.this.myValuesPanel, propertyName == null ? ResourceBundleEditor.NO_PROPERTY_SELECTED : ResourceBundleEditor.VALUES);
                    if (propertyName == null) {
                        return;
                    }
                    List<PropertiesFile> propertiesFiles = ResourceBundleEditor.this.myResourceBundle.getPropertiesFiles(ResourceBundleEditor.this.myProject);
                    for (PropertiesFile propertiesFile : propertiesFiles) {
                        String rawValue;
                        EditorEx editor = (EditorEx)ResourceBundleEditor.this.myEditors.get(propertiesFile);
                        if (editor == null) continue;
                        ResourceBundleEditor.reinitSettings(editor);
                        IProperty property = propertiesFile.findPropertyByKey(propertyName);
                        final String value = property == null ? "" : ((rawValue = property.getValue()) == null ? "" : ResourceBundleUtil.fromPropertyValueToValueEditor(rawValue));
                        DocumentEx document = editor.getDocument();
                        CommandProcessor.getInstance().executeCommand(null, new Runnable((Document)document, propertiesFile){
                            final /* synthetic */ Document val$document;
                            final /* synthetic */ PropertiesFile val$propertiesFile;
                            {
                                this.val$document = document;
                                this.val$propertiesFile = propertiesFile;
                            }

                            @Override
                            public void run() {
                                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        ResourceBundleEditor.this.updateDocumentFromPropertyValue(value, val$document, val$propertiesFile);
                                    }
                                });
                            }
                        }, "", (Object)this);
                        JPanel titledPanel = (JPanel)ResourceBundleEditor.this.myTitledPanels.get(propertiesFile);
                        ((TitledBorder)titledPanel.getBorder()).setTitleColor((Color)(property == null ? JBColor.RED : UIUtil.getLabelTextForeground()));
                        titledPanel.repaint();
                    }
                }
                finally {
                    ResourceBundleEditor.this.installDocumentListeners();
                }
            }
        }, 200);
    }

    private void updateDocumentFromPropertyValue(String value, Document document, PropertiesFile propertiesFile) {
        String text = value;
        if (this.myBackSlashPressed.contains(propertiesFile)) {
            text = text + "\\";
        }
        document.replaceString(0, document.getTextLength(), (CharSequence)text);
    }

    private void updatePropertyValueFromDocument(String propertyName, PropertiesFile propertiesFile, String text) {
        if (PropertiesUtil.isUnescapedBackSlashAtTheEnd(text)) {
            this.myBackSlashPressed.add(propertiesFile);
        } else {
            this.myBackSlashPressed.remove(propertiesFile);
        }
        IProperty property = propertiesFile.findPropertyByKey(propertyName);
        try {
            if (property == null) {
                propertiesFile.addProperty(propertyName, text);
            } else {
                property.setValue(text);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void installDocumentListeners() {
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        for (final PropertiesFile propertiesFile : propertiesFiles) {
            EditorEx editor = (EditorEx)this.myEditors.get(propertiesFile);
            if (editor == null) continue;
            DocumentAdapter listener = new DocumentAdapter(){
                private String oldText;

                public void beforeDocumentChange(DocumentEvent e) {
                    this.oldText = e.getDocument().getText();
                }

                public void documentChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    String text = document.getText();
                    ResourceBundleEditor.this.updatePropertyValueFor(document, propertiesFile, text, this.oldText);
                }
            };
            this.myDocumentListeners.put((Editor)editor, (DocumentListener)listener);
            editor.getDocument().addDocumentListener((DocumentListener)listener);
        }
    }

    private void uninstallDocumentListeners() {
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        for (PropertiesFile propertiesFile : propertiesFiles) {
            Editor editor = this.myEditors.get(propertiesFile);
            this.uninstallDocumentListener(editor);
        }
    }

    private void uninstallDocumentListener(Editor editor) {
        DocumentListener listener = this.myDocumentListeners.remove(editor);
        if (listener != null) {
            editor.getDocument().removeDocumentListener(listener);
        }
    }

    private void updatePropertyValueFor(final Document document, final PropertiesFile propertiesFile, final String text, final String oldText) {
        this.myUpdatePsiAlarm.cancelAllRequests();
        this.myUpdatePsiAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!ResourceBundleEditor.this.isValid()) {
                    return;
                }
                DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Project project = propertiesFile.getProject();
                        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                        documentManager.commitDocument(document);
                        Document propertiesFileDocument = documentManager.getDocument(propertiesFile.getContainingFile());
                        if (propertiesFileDocument == null) {
                            return;
                        }
                        documentManager.commitDocument(propertiesFileDocument);
                        if (!FileDocumentManager.getInstance().requestWriting(document, project)) {
                            ResourceBundleEditor.this.uninstallDocumentListeners();
                            try {
                                document.replaceString(0, document.getTextLength(), (CharSequence)oldText);
                            }
                            finally {
                                ResourceBundleEditor.this.installDocumentListeners();
                            }
                            return;
                        }
                        String propertyName = ResourceBundleEditor.this.getSelectedPropertyName();
                        if (propertyName == null) {
                            return;
                        }
                        ResourceBundleEditor.this.updatePropertyValueFromDocument(propertyName, propertiesFile, text);
                    }
                });
            }
        }, 300, ModalityState.stateForComponent((Component)this.getComponent()));
    }

    @Nullable
    private String getSelectedPropertyName() {
        JTree tree = this.myStructureViewComponent.getTree();
        if (tree == null) {
            return null;
        }
        TreePath selected = tree.getSelectionModel().getSelectionPath();
        if (selected == null) {
            return null;
        }
        return ResourceBundleEditor.getNodeValue((DefaultMutableTreeNode)selected.getLastPathComponent());
    }

    @NotNull
    public JComponent getComponent() {
        DataProviderPanel dataProviderPanel = this.myDataProviderPanel;
        if (dataProviderPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getComponent"));
        }
        return dataProviderPanel;
    }

    private Object getData(String dataId) {
        if (SelectInContext.DATA_KEY.is(dataId)) {
            return new SelectInContext(){

                @NotNull
                public Project getProject() {
                    Project project = ResourceBundleEditor.this.myProject;
                    if (project == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor$13", "getProject"));
                    }
                    return project;
                }

                @NotNull
                public VirtualFile getVirtualFile() {
                    VirtualFile virtualFile;
                    PropertiesFile selectedFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    VirtualFile virtualFile2 = virtualFile = selectedFile == null ? null : selectedFile.getVirtualFile();
                    assert (virtualFile != null);
                    VirtualFile virtualFile3 = virtualFile;
                    if (virtualFile3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor$13", "getVirtualFile"));
                    }
                    return virtualFile3;
                }

                public Object getSelectorInFile() {
                    return ResourceBundleEditor.this.getSelectedPropertiesFile();
                }

                public FileEditorProvider getFileEditorProvider() {
                    final PropertiesFile selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    if (selectedPropertiesFile == null) {
                        return null;
                    }
                    return new FileEditorProvider(){

                        public FileEditor openFileEditor() {
                            VirtualFile file = selectedPropertiesFile.getVirtualFile();
                            if (file == null) {
                                return null;
                            }
                            return FileEditorManager.getInstance((Project)this.getProject()).openFile(file, false)[0];
                        }
                    };
                }
            };
        }
        return null;
    }

    private PropertiesFile getSelectedPropertiesFile() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        PropertiesFile selectedFile = null;
        for (PropertiesFile file : this.myEditors.keySet()) {
            Editor editor = this.myEditors.get(file);
            if (editor != this.mySelectedEditor) continue;
            selectedFile = file;
            break;
        }
        return selectedFile;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStructureViewPanel;
    }

    @NotNull
    public String getName() {
        if ("Resource Bundle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getName"));
        }
        return "Resource Bundle";
    }

    @NotNull
    public ResourceBundleEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getState"));
        }
        ResourceBundleEditorState resourceBundleEditorState = new ResourceBundleEditorState(this.getSelectedPropertyName());
        if (resourceBundleEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditor", "getState"));
        }
        return resourceBundleEditorState;
    }

    private JBSplitter getSplitter() {
        return (JBSplitter)this.mySplitParent.getComponents()[0];
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "setState"));
        }
        ResourceBundleEditorState myState = (ResourceBundleEditorState)state;
        String propertyName = myState.myPropertyName;
        if (propertyName != null) {
            this.myStructureViewComponent.select((Object)propertyName, true);
            this.selectionChanged();
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return !this.myDisposed && !this.myProject.isDisposed();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "removePropertyChangeListener"));
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener(this.myVfsListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myStructureViewComponent);
        this.releaseAllEditors();
    }

    private void releaseAllEditors() {
        for (Editor editor : this.myEditors.values()) {
            this.releaseEditor(editor);
        }
        this.myEditors.clear();
    }

    private void releaseEditor(Editor editor) {
        if (!editor.isDisposed()) {
            this.uninstallDocumentListener(editor);
            EditorFactory.getInstance().releaseEditor(editor);
        }
    }

    public void renameProperty(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleEditor", "renameProperty"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/editor/ResourceBundleEditor", "renameProperty"));
        }
        for (PropertiesFile properties : this.myResourceBundle.getPropertiesFiles(this.myProject)) {
            IProperty property = properties.findPropertyByKey(oldName);
            if (property == null) continue;
            property.setName(newName);
        }
    }

    private static Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(document);
        ResourceBundleEditor.reinitSettings(editor);
        return editor;
    }

    private static void reinitSettings(EditorEx editor) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setWhitespacesShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new PropertiesValueHighlighter(), scheme));
        editor.setVerticalScrollbarVisible(true);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitParent = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), 5, 5, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(347);
        jPanel3.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myStructureViewPanel = jPanel2 = new JPanel();
        jSplitPane.setLeftComponent(jPanel2);
        this.myValuesPanel = jPanel = new JPanel();
        jSplitPane.setRightComponent(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyJPanel
    extends JPanel
    implements Scrollable {
        private MyJPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            Editor editor = (Editor)ResourceBundleEditor.this.myEditors.values().iterator().next();
            return editor.getLineHeight() * 4;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class DataProviderPanel
    extends JPanel
    implements DataProvider {
        private DataProviderPanel(JPanel panel) {
            super(new BorderLayout());
            this.add((Component)panel, "Center");
        }

        @Nullable
        public Object getData(String dataId) {
            return ResourceBundleEditor.this.getData(dataId);
        }
    }

    public static class ResourceBundleEditorState
    implements FileEditorState {
        private final String myPropertyName;

        public ResourceBundleEditorState(String propertyName) {
            this.myPropertyName = propertyName;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }

        public String getPropertyName() {
            return this.myPropertyName;
        }
    }
}

