/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

@Presentation(icon="AllIcons.Nodes.ResourceBundle")
public class ResourceBundleAsVirtualFile
extends VirtualFile {
    private final ResourceBundle myResourceBundle;

    public ResourceBundleAsVirtualFile(ResourceBundle resourceBundle) {
        this.myResourceBundle = resourceBundle;
    }

    public ResourceBundle getResourceBundle() {
        return this.myResourceBundle;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile", "getFileSystem"));
        }
        return localFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myResourceBundle.getBaseName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile", "getName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleAsVirtualFile resourceBundleAsVirtualFile = (ResourceBundleAsVirtualFile)((Object)o);
        return this.myResourceBundle.equals(resourceBundleAsVirtualFile.myResourceBundle);
    }

    public int hashCode() {
        return this.myResourceBundle.hashCode();
    }

    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile", "rename"));
        }
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myResourceBundle.getBaseDirectory();
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public VirtualFile createChildDirectory(Object requestor, String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile", "createChildData"));
        }
        throw new UnsupportedOperationException();
    }

    public void delete(Object requestor) throws IOException {
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile", "move"));
        }
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }
}

