/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TrailingSpacesInPropertyInspection
extends PropertySuppressableInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = PropertiesBundle.message("trail.spaces.property.inspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("TrailingSpacesInProperty" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection", "getShortName"));
        }
        return "TrailingSpacesInProperty";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection", "checkFile"));
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        List<IProperty> properties = ((PropertiesFile)file).getProperties();
        SmartList descriptors = new SmartList();
        for (IProperty property : properties) {
            PsiElement value;
            TextRange textRange;
            ASTNode valueNode;
            PsiElement key;
            TextRange textRange2;
            ProgressManager.checkCanceled();
            ASTNode keyNode = ((PropertyImpl)property).getKeyNode();
            if (keyNode != null && (textRange2 = TrailingSpacesInPropertyInspection.getTrailingSpaces(key = keyNode.getPsi())) != null) {
                descriptors.add(manager.createProblemDescriptor(key, textRange2, "Trailing Spaces", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{RemoveTrailingSpacesFix.INSTANCE}));
            }
            if ((valueNode = ((PropertyImpl)property).getValueNode()) == null || (textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(value = valueNode.getPsi())) == null) continue;
            descriptors.add(manager.createProblemDescriptor(value, textRange, "Trailing Spaces", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{RemoveTrailingSpacesFix.INSTANCE}));
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    private static TextRange getTrailingSpaces(PsiElement element) {
        String key = element.getText();
        return PropertyImpl.trailingSpaces(key);
    }

    private static class RemoveTrailingSpacesFix
    implements LocalQuickFix {
        private static final RemoveTrailingSpacesFix INSTANCE = new RemoveTrailingSpacesFix();

        private RemoveTrailingSpacesFix() {
        }

        @NotNull
        public String getName() {
            if ("Remove Trailing Spaces" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "getName"));
            }
            return "Remove Trailing Spaces";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement parent;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/TrailingSpacesInPropertyInspection$RemoveTrailingSpacesFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PropertyImpl)) {
                return;
            }
            TextRange textRange = TrailingSpacesInPropertyInspection.getTrailingSpaces(element);
            if (textRange != null) {
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(element.getContainingFile());
                TextRange docRange = textRange.shiftRight(element.getTextRange().getStartOffset());
                document.deleteString(docRange.getStartOffset(), docRange.getEndOffset());
            }
        }
    }
}

