/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PropertyManipulator
extends AbstractElementManipulator<PropertyImpl> {
    public PropertyImpl handleContentChange(@NotNull PropertyImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/PropertyManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/PropertyManipulator", "handleContentChange"));
        }
        TextRange valueRange = this.getRangeInElement(element);
        String oldText = element.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        element.setValue(newText.substring(valueRange.getStartOffset()).replaceAll("([^\\s])\n", "$1 \n"));
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PropertyImpl element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/PropertyManipulator", "getRangeInElement"));
        }
        ASTNode valueNode = element.getValueNode();
        if (valueNode == null) {
            TextRange textRange = TextRange.from((int)element.getTextLength(), (int)0);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertyManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        TextRange range = valueNode.getTextRange();
        TextRange textRange = TextRange.from((int)(range.getStartOffset() - element.getTextRange().getStartOffset()), (int)range.getLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertyManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

