/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static boolean isPropertiesFile(VirtualFile file, Project project) {
        return PropertiesUtil.getPropertiesFile(PsiManager.getInstance((Project)project).findFile(file)) != null;
    }

    public static boolean isPropertiesFile(PsiFile file) {
        return PropertiesUtil.getPropertiesFile(file) != null;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        return file instanceof PropertiesFile ? (PropertiesFile)file : XmlPropertiesFile.getPropertiesFile(file);
    }

    @NotNull
    public static List<IProperty> findPropertiesByKey(final Project project, final String key) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        final ArrayList<IProperty> properties = new ArrayList<IProperty>(PropertyKeyIndex.getInstance().get(key, project, scope));
        final HashSet files = new HashSet();
        FileBasedIndex.getInstance().processValues(XmlPropertiesIndex.NAME, (Object)new XmlPropertiesIndex.Key(key), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<String>(){

            public boolean process(VirtualFile file, String value) {
                PsiFile psiFile;
                PropertiesFile propertiesFile;
                if (files.add(file) && (propertiesFile = XmlPropertiesFile.getPropertiesFile(psiFile = PsiManager.getInstance((Project)project).findFile(file))) != null) {
                    properties.addAll(propertiesFile.findPropertiesByKey(key));
                }
                return false;
            }
        }, scope);
        ArrayList<IProperty> arrayList = properties;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "findPropertiesByKey"));
        }
        return arrayList;
    }

    public static boolean isPropertyComplete(Project project, ResourceBundle resourceBundle, String propertyName) {
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles(project);
        for (PropertiesFile propertiesFile : propertiesFiles) {
            if (propertiesFile.findPropertyByKey(propertyName) != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String getBaseName(@NotNull VirtualFile virtualFile) {
        String part;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/PropertiesUtil", "getBaseName"));
        }
        String name = virtualFile.getNameWithoutExtension();
        List parts = StringUtil.split((String)name, (String)"_");
        if (parts.size() == 1) {
            String string = (String)parts.get(0);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getBaseName"));
            }
            return string;
        }
        if (parts.size() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getBaseName"));
            }
            return "";
        }
        String baseName = (String)parts.get(0);
        for (int i = 1; i < parts.size() && (part = (String)parts.get(i)).length() != 2; ++i) {
            baseName = baseName + "_";
            baseName = baseName + part;
        }
        String string = baseName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getBaseName"));
        }
        return string;
    }

    @Nullable
    public static PropertiesFile getParent(PropertiesFile file, List<PropertiesFile> candidates) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String name = virtualFile.getNameWithoutExtension();
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return null;
        }
        List<String> partsList = Arrays.asList(parts);
        for (int i = parts.length - 1; i >= 1; --i) {
            String parentName = StringUtil.join(partsList.subList(0, i), (String)"_") + "." + virtualFile.getExtension();
            for (PropertiesFile candidate : candidates) {
                if (!parentName.equals(candidate.getName())) continue;
                return candidate;
            }
        }
        return null;
    }

    @Nullable
    public static String getFullName(final PropertiesFile psiFile) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<String>(){

            public String compute() {
                PsiDirectory directory = psiFile.getParent();
                String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
                if (packageQualifiedName == null) {
                    return null;
                }
                StringBuilder qName = new StringBuilder(packageQualifiedName);
                if (qName.length() > 0) {
                    qName.append(".");
                }
                VirtualFile virtualFile = psiFile.getVirtualFile();
                assert (virtualFile != null);
                qName.append(PropertiesUtil.getBaseName(virtualFile));
                return qName.toString();
            }
        });
    }

    @NotNull
    public static Locale getLocale(VirtualFile propertiesFile) {
        String name = propertiesFile.getNameWithoutExtension();
        String tail = StringUtil.trimStart((String)name, (String)PropertiesUtil.getBaseName(propertiesFile));
        String[] parts = (tail = StringUtil.trimStart((String)tail, (String)"_")).split("_");
        String language = parts.length == 0 ? "" : parts[0];
        String country = "";
        String variant = "";
        if (parts.length >= 2 && parts[1].length() == 2) {
            country = parts[1];
            for (int i = 2; i < parts.length; ++i) {
                String part = parts[i];
                if (variant.length() != 0) {
                    variant = variant + "_";
                }
                variant = variant + part;
            }
        }
        Locale locale = new Locale(language, country, variant);
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getLocale"));
        }
        return locale;
    }

    @NotNull
    public static List<IProperty> findAllProperties(Project project, @NotNull ResourceBundle resourceBundle, String key) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles(project);
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        return smartList;
    }

    public static boolean isUnescapedBackSlashAtTheEnd(String text) {
        boolean result = false;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            result = !result;
        }
        return result;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull String bundleName, @NotNull Module searchFromModule, @Nullable Locale locale) {
        if (bundleName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/PropertiesUtil", "getPropertiesFile"));
        }
        if (searchFromModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/PropertiesUtil", "getPropertiesFile"));
        }
        PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance(searchFromModule.getProject());
        return manager.findPropertiesFile(searchFromModule, bundleName, locale);
    }

    @Nullable
    public static String getPackageQualifiedName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/PropertiesUtil", "getPackageQualifiedName"));
        }
        return ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex().getPackageNameByDirectory(directory.getVirtualFile());
    }

    public static ResourceBundle getResourceBundle(final PsiFile containingFile) {
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (!containingFile.isValid() || virtualFile == null) {
            return ResourceBundleImpl.NULL;
        }
        String baseName = PropertiesUtil.getBaseName(virtualFile);
        PsiDirectory directory = (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

            @Nullable
            public PsiDirectory compute() {
                return containingFile.getContainingDirectory();
            }
        });
        if (directory == null) {
            return ResourceBundleImpl.NULL;
        }
        return new ResourceBundleImpl(directory.getVirtualFile(), baseName);
    }
}

