/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;

public class IdeaContentRootImpl
implements ExtIdeaContentRoot {
    private final File myRootDirectory;
    private final List<IdeaSourceDirectory> mySourceDirectories;
    private final List<IdeaSourceDirectory> myTestDirectories;
    private final List<IdeaSourceDirectory> myResourceDirectories;
    private final List<IdeaSourceDirectory> myTestResourceDirectories;
    private final Set<File> myExcludeDirectories;

    public IdeaContentRootImpl(File rootDirectory) {
        this.myRootDirectory = rootDirectory;
        this.mySourceDirectories = new ArrayList<IdeaSourceDirectory>();
        this.myTestDirectories = new ArrayList<IdeaSourceDirectory>();
        this.myResourceDirectories = new ArrayList<IdeaSourceDirectory>();
        this.myTestResourceDirectories = new ArrayList<IdeaSourceDirectory>();
        this.myExcludeDirectories = new HashSet<File>();
    }

    public File getRootDirectory() {
        return this.myRootDirectory;
    }

    public DomainObjectSet<? extends IdeaSourceDirectory> getSourceDirectories() {
        return ImmutableDomainObjectSet.of(this.mySourceDirectories);
    }

    public void addSourceDirectory(IdeaSourceDirectory sourceDirectory) {
        this.mySourceDirectories.add(sourceDirectory);
    }

    public void addTestDirectory(IdeaSourceDirectory testDirectory) {
        this.myTestDirectories.add(testDirectory);
    }

    public void addResourceDirectory(IdeaSourceDirectory resourceDirectory) {
        this.myResourceDirectories.add(resourceDirectory);
    }

    public void addTestResourceDirectory(IdeaSourceDirectory resourceDirectory) {
        this.myTestResourceDirectories.add(resourceDirectory);
    }

    public void addExcludeDirectory(File excludeDirectory) {
        this.myExcludeDirectories.add(excludeDirectory);
    }

    public DomainObjectSet<? extends IdeaSourceDirectory> getTestDirectories() {
        return ImmutableDomainObjectSet.of(this.myTestDirectories);
    }

    public DomainObjectSet<? extends IdeaSourceDirectory> getResourceDirectories() {
        return ImmutableDomainObjectSet.of(this.myResourceDirectories);
    }

    public DomainObjectSet<? extends IdeaSourceDirectory> getTestResourceDirectories() {
        return ImmutableDomainObjectSet.of(this.myTestResourceDirectories);
    }

    public Set<File> getExcludeDirectories() {
        return this.myExcludeDirectories;
    }
}

