/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.serialize;

import java.io.File;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.DefaultSerializer;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSerializerFactory {
    public static final Serializer<String> STRING_SERIALIZER = new StringSerializer();
    public static final Serializer LONG_SERIALIZER = new LongSerializer();
    public static final Serializer FILE_SERIALIZER = new FileSerializer();

    public <T> Serializer<T> getSerializerFor(Class<T> type) {
        if (type.equals(String.class)) {
            Serializer<String> stringSerializer = STRING_SERIALIZER;
            return stringSerializer;
        }
        if (type.equals(Long.class)) {
            return LONG_SERIALIZER;
        }
        if (type.equals(File.class)) {
            return FILE_SERIALIZER;
        }
        return new DefaultSerializer(type.getClassLoader());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSerializer
    implements Serializer<File> {
        private FileSerializer() {
        }

        @Override
        public File read(Decoder decoder) throws Exception {
            return new File(decoder.readString());
        }

        @Override
        public void write(Encoder encoder, File value) throws Exception {
            encoder.writeString(value.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringSerializer
    implements Serializer<String> {
        private StringSerializer() {
        }

        @Override
        public String read(Decoder decoder) throws Exception {
            return decoder.readString();
        }

        @Override
        public void write(Encoder encoder, String value) throws Exception {
            encoder.writeString(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongSerializer
    implements Serializer<Long> {
        private LongSerializer() {
        }

        @Override
        public Long read(Decoder decoder) throws Exception {
            return decoder.readLong();
        }

        @Override
        public void write(Encoder encoder, Long value) throws Exception {
            encoder.writeLong(value);
        }
    }
}

