/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.rules;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.model.ModelFinalizer;
import org.gradle.model.ModelPath;
import org.gradle.model.ModelRule;
import org.gradle.model.Path;
import org.gradle.model.internal.Inputs;
import org.gradle.model.internal.ModelCreationListener;
import org.gradle.model.internal.ModelMutator;
import org.gradle.model.internal.ModelRegistry;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveRule {
    public static void rule(final ModelRegistry modelRegistry, final ModelRule modelRule) {
        final Method bindingMethod = ReflectiveRule.findBindingMethod(modelRule);
        final List<BindableParameter<?>> initialBindings = ReflectiveRule.bindings(bindingMethod);
        boolean unsatisfied = CollectionUtils.any(initialBindings, (Spec)new Spec<BindableParameter<?>>(){

            public boolean isSatisfiedBy(BindableParameter<?> element) {
                return element.getPath() == null;
            }
        });
        if (unsatisfied) {
            modelRegistry.registerListener(new ModelCreationListener(){
                private List<BindableParameter<?>> bindings;
                {
                    this.bindings = initialBindings;
                }

                @Override
                public boolean onCreate(ModelPath path, Class<?> type) {
                    ImmutableList.Builder bindingsBuilder = ImmutableList.builder();
                    boolean unsatisfied = false;
                    for (BindableParameter<?> binding : this.bindings) {
                        if (binding.getPath() == null) {
                            if (binding.getType().isAssignableFrom(type)) {
                                bindingsBuilder.add((Object)ReflectiveRule.copyBindingWithPath(path, binding));
                                continue;
                            }
                            unsatisfied = true;
                        }
                        bindingsBuilder.add(binding);
                    }
                    this.bindings = bindingsBuilder.build();
                    if (unsatisfied) {
                        return false;
                    }
                    ReflectiveRule.registerMutator(modelRegistry, modelRule, bindingMethod, this.bindings);
                    return true;
                }
            });
        } else {
            ReflectiveRule.registerMutator(modelRegistry, modelRule, bindingMethod, initialBindings);
        }
    }

    private static void registerMutator(ModelRegistry modelRegistry, ModelRule modelRule, Method bindingMethod, List<BindableParameter<?>> bindings) {
        BindableParameter<?> first = bindings.get(0);
        List<BindableParameter<?>> tail = bindings.subList(1, bindings.size());
        ModelMutator<?> modelMutator = ReflectiveRule.toMutator(modelRule, bindingMethod, first, tail);
        String path = first.getPath().toString();
        List bindingPaths = CollectionUtils.collect(tail, (Transformer)new Transformer<String, BindableParameter<?>>(){

            public String transform(BindableParameter<?> bindableParameter) {
                return bindableParameter.getPath().toString();
            }
        });
        if (modelRule instanceof ModelFinalizer) {
            modelRegistry.finalize(path, bindingPaths, modelMutator);
        } else {
            modelRegistry.mutate(path, bindingPaths, modelMutator);
        }
    }

    private static <T> ModelMutator<T> toMutator(final ModelRule modelRule, final Method bindingMethod, final BindableParameter<T> first, final List<BindableParameter<?>> tail) {
        return new ModelMutator<T>(){

            @Override
            public Class<T> getType() {
                return first.getType();
            }

            @Override
            public void mutate(T object, Inputs inputs) {
                Object[] args = new Object[1 + tail.size()];
                args[0] = object;
                for (int i = 0; i < inputs.size(); ++i) {
                    args[i + 1] = inputs.get(i, ((BindableParameter)tail.get(i)).getType());
                }
                bindingMethod.setAccessible(true);
                try {
                    bindingMethod.invoke((Object)modelRule, args);
                }
                catch (Exception e) {
                    Throwable t = e;
                    if (t instanceof InvocationTargetException) {
                        t = e.getCause();
                    }
                    UncheckedException.throwAsUncheckedException((Throwable)t);
                }
            }
        };
    }

    private static <T> BindableParameter<T> copyBindingWithPath(ModelPath path, BindableParameter<T> binding) {
        return new BindableParameter<T>(path, binding.getType());
    }

    public static Method findBindingMethod(Object object) {
        Class<?> objectClass = object.getClass();
        List declaredMethods = CollectionUtils.filter(Arrays.asList(objectClass.getDeclaredMethods()), (Spec)new Spec<Method>(){

            public boolean isSatisfiedBy(Method element) {
                int modifiers = element.getModifiers();
                return !Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers) && !element.isSynthetic();
            }
        });
        if (declaredMethods.size() != 1) {
            throw new IllegalArgumentException(objectClass + " rule must have exactly 1 public method, has: " + CollectionUtils.join((String)", ", (Iterable)CollectionUtils.toStringList((Iterable)declaredMethods)));
        }
        return (Method)declaredMethods.get(0);
    }

    private static List<BindableParameter<?>> bindings(Method method) {
        return ReflectiveRule.bindings(method.getParameterTypes(), method.getParameterAnnotations());
    }

    static List<BindableParameter<?>> bindings(Class[] types, Annotation[][] annotations) {
        ImmutableList.Builder inputBindingBuilder = ImmutableList.builder();
        for (int i = 0; i < types.length; ++i) {
            Class paramType = types[i];
            Annotation[] paramAnnotations = annotations[i];
            inputBindingBuilder.add((Object)ReflectiveRule.binding(paramType, paramAnnotations));
        }
        return inputBindingBuilder.build();
    }

    private static <T> BindableParameter binding(Class<T> type, Annotation[] annotations) {
        Path pathAnnotation = (Path)CollectionUtils.findFirst((Object[])annotations, (Spec)new Spec<Annotation>(){

            public boolean isSatisfiedBy(Annotation element) {
                return element.annotationType().equals(Path.class);
            }
        });
        String path = pathAnnotation == null ? null : pathAnnotation.value();
        return new BindableParameter<T>(path == null ? null : ModelPath.path(path), type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BindableParameter<T> {
        private final ModelPath path;
        private final Class<T> type;

        public BindableParameter(@Nullable ModelPath path, Class<T> type) {
            this.path = path;
            this.type = type;
        }

        public ModelPath getPath() {
            return this.path;
        }

        public Class<T> getType() {
            return this.type;
        }
    }
}

