/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;

public class SettingsHandler {
    private ISettingsFinder settingsFinder;
    private SettingsProcessor settingsProcessor;
    private BuildSourceBuilder buildSourceBuilder;

    public SettingsHandler(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        SettingsInternal settings = this.findSettingsAndLoadIfAppropriate(gradle, startParameter);
        ProjectSpec spec = ProjectSpecs.forStartParameter(startParameter);
        if (!spec.containsProject(settings.getProjectRegistry())) {
            StartParameter noSearchParameter = startParameter.newInstance();
            noSearchParameter.useEmptySettings();
            settings = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter);
            if (settings == null) {
                throw new InternalError("Empty settings file does not contain expected project.");
            }
            if (noSearchParameter.getBuildFile() != null) {
                ProjectDescriptor rootProject = settings.getRootProject();
                assert (noSearchParameter.getBuildFile().getParentFile().equals(rootProject.getProjectDir()));
                rootProject.setBuildFileName(noSearchParameter.getBuildFile().getName());
            }
        }
        return settings;
    }

    private SettingsInternal findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter) {
        SettingsLocation settingsLocation = this.findSettings(startParameter);
        StartParameter buildSrcStartParameter = startParameter.newBuild();
        buildSrcStartParameter.setCurrentDir(new File(settingsLocation.getSettingsDir(), "buildSrc"));
        ClassLoaderScope buildSourceClassLoader = this.buildSourceBuilder.buildAndCreateClassLoader(buildSrcStartParameter);
        return this.loadSettings(gradle, settingsLocation, buildSourceClassLoader.createChild().lock(), startParameter);
    }

    private SettingsLocation findSettings(StartParameter startParameter) {
        return this.settingsFinder.find(startParameter);
    }

    private SettingsInternal loadSettings(GradleInternal gradle, SettingsLocation settingsLocation, ClassLoaderScope baseClassLoaderScope, StartParameter startParameter) {
        return this.settingsProcessor.process(gradle, settingsLocation, baseClassLoaderScope, startParameter);
    }
}

