/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URLClassLoader;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.JdkToolsInitializer;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.Jvm;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry,
JdkToolsInitializer {
    private final ClassLoader apiOnlyClassLoader;
    private final ClassLoader apiAndPluginsClassLoader;
    private final ClassLoader coreImplClassLoader;
    private final ClassLoader pluginsClassLoader;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory) {
        ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
        ClassPath coreImplClassPath = classPathRegistry.getClassPath("GRADLE_CORE_IMPL");
        this.coreImplClassLoader = new MutableURLClassLoader(runtimeClassLoader, coreImplClassPath);
        this.apiOnlyClassLoader = this.restrictToGradleApi(classLoaderFactory, this.coreImplClassLoader);
        ClassPath pluginsClassPath = classPathRegistry.getClassPath("GRADLE_PLUGINS");
        CachingClassLoader pluginsImports = new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{runtimeClassLoader, this.coreImplClassLoader}));
        this.pluginsClassLoader = new MutableURLClassLoader((ClassLoader)pluginsImports, pluginsClassPath);
        this.apiAndPluginsClassLoader = this.restrictToGradleApi(classLoaderFactory, this.pluginsClassLoader);
    }

    private CachingClassLoader restrictToGradleApi(ClassLoaderFactory classLoaderFactory, ClassLoader classLoader) {
        FilteringClassLoader rootClassLoader = classLoaderFactory.createFilteringClassLoader(classLoader);
        rootClassLoader.allowPackage("org.gradle");
        rootClassLoader.allowResources("META-INF/gradle-plugins");
        rootClassLoader.allowPackage("org.apache.tools.ant");
        rootClassLoader.allowPackage("groovy");
        rootClassLoader.allowPackage("org.codehaus.groovy");
        rootClassLoader.allowPackage("groovyjarjarantlr");
        rootClassLoader.allowPackage("org.slf4j");
        rootClassLoader.allowPackage("org.apache.commons.logging");
        rootClassLoader.allowPackage("org.apache.log4j");
        rootClassLoader.allowPackage("javax.inject");
        return new CachingClassLoader((ClassLoader)rootClassLoader);
    }

    public void initializeJdkTools() {
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            ClassLoader systemClassLoaderParent = ClassLoader.getSystemClassLoader().getParent();
            ClasspathUtil.addUrl((URLClassLoader)((URLClassLoader)systemClassLoaderParent), (Iterable)new DefaultClassPath(new File[]{toolsJar}).getAsURLs());
        }
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getGradleApiClassLoader() {
        return this.apiAndPluginsClassLoader;
    }

    public ClassLoader getCoreImplClassLoader() {
        return this.coreImplClassLoader;
    }

    public ClassLoader getPluginsClassLoader() {
        return this.pluginsClassLoader;
    }

    public ClassLoader getGradleCoreApiClassLoader() {
        return this.apiOnlyClassLoader;
    }
}

