/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.specs.Spec;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.groovy.scripts.internal.StatementTransformer;
import org.gradle.plugin.use.internal.PluginDependenciesService;
import org.gradle.plugin.use.internal.PluginUseScriptBlockTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsAndBuildscriptTransformer
implements StatementTransformer {
    private static final String PLUGINS = "plugins";
    private static final PluginUseScriptBlockTransformer PLUGIN_BLOCK_TRANSFORMER = new PluginUseScriptBlockTransformer("__scriptServices", PluginDependenciesService.class);
    private final String classpathBlockName;
    private final String pluginsBlockMessage;
    private boolean seenNonClasspathStatement;
    private boolean seenPluginsBlock;

    public PluginsAndBuildscriptTransformer(String classpathBlockName, String pluginsBlockMessage) {
        this.classpathBlockName = classpathBlockName;
        this.pluginsBlockMessage = pluginsBlockMessage;
    }

    @Override
    public Statement transform(SourceUnit sourceUnit, Statement statement) {
        ScriptBlock scriptBlock = this.detectScriptBlock(statement);
        if (scriptBlock == null) {
            this.seenNonClasspathStatement = true;
            return null;
        }
        if (scriptBlock.getName().equals(PLUGINS)) {
            String failMessage = null;
            Statement returnStatement = statement;
            if (this.pluginsBlockMessage != null) {
                failMessage = this.pluginsBlockMessage;
            } else {
                this.seenPluginsBlock = true;
                if (this.seenNonClasspathStatement) {
                    failMessage = String.format("only %s {} and other %s {} script blocks are allowed before %s {} blocks, no other statements are allowed", this.classpathBlockName, PLUGINS, PLUGINS);
                } else {
                    returnStatement = PLUGIN_BLOCK_TRANSFORMER.transform(sourceUnit, scriptBlock);
                }
            }
            if (failMessage != null) {
                sourceUnit.getErrorCollector().addError(new SyntaxException(failMessage, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
            }
            return returnStatement;
        }
        if (this.seenPluginsBlock) {
            String message = String.format("all %s {} blocks must appear before any %s {} blocks in the script", this.classpathBlockName, PLUGINS);
            sourceUnit.getErrorCollector().addError(new SyntaxException(message, statement.getLineNumber(), statement.getColumnNumber()), sourceUnit);
        }
        return statement;
    }

    public Spec<Statement> getSpec() {
        return new Spec<Statement>(){

            public boolean isSatisfiedBy(Statement statement) {
                return PluginsAndBuildscriptTransformer.this.detectScriptBlock(statement) != null;
            }
        };
    }

    private ScriptBlock detectScriptBlock(Statement statement) {
        if (!(statement instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        if (!(expressionStatement.getExpression() instanceof MethodCallExpression)) {
            return null;
        }
        MethodCallExpression methodCall = (MethodCallExpression)expressionStatement.getExpression();
        if (!AstUtils.targetIsThis(methodCall)) {
            return null;
        }
        if (!(methodCall.getMethod() instanceof ConstantExpression)) {
            return null;
        }
        String methodName = methodCall.getMethod().getText();
        if (methodName.equals(PLUGINS) || methodName.equals(this.classpathBlockName)) {
            if (!(methodCall.getArguments() instanceof ArgumentListExpression)) {
                return null;
            }
            ArgumentListExpression args = (ArgumentListExpression)methodCall.getArguments();
            if (args.getExpressions().size() == 1 && args.getExpression(0) instanceof ClosureExpression) {
                return new ScriptBlock(methodName, (ClosureExpression)args.getExpression(0));
            }
            return null;
        }
        return null;
    }
}

