/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.util.Clock;

abstract class AbstractTaskPlanExecutor
implements TaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(AbstractTaskPlanExecutor.class);
    private final Object lock = new Object();

    AbstractTaskPlanExecutor() {
    }

    protected Runnable taskWorker(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
        return new TaskExecutorWorker(taskExecutionPlan, taskListener);
    }

    private class TaskExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final TaskExecutionListener taskListener;

        private TaskExecutorWorker(TaskExecutionPlan taskExecutionPlan, TaskExecutionListener taskListener) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.taskListener = taskListener;
        }

        public void run() {
            TaskInfo task;
            long busy = 0L;
            long start = System.currentTimeMillis();
            while ((task = this.taskExecutionPlan.getTaskToExecute()) != null) {
                String taskPath = task.getTask().getPath();
                LOGGER.info("{} ({}) started.", taskPath, Thread.currentThread());
                long startTask = System.currentTimeMillis();
                this.processTask(task);
                long taskDuration = System.currentTimeMillis() - startTask;
                busy += taskDuration;
                LOGGER.info("{} ({}) completed. Took {}.", taskPath, Thread.currentThread(), Clock.prettyTime(taskDuration));
            }
            long total = System.currentTimeMillis() - start;
            LOGGER.debug("Task worker [{}] finished, busy: {}, idle: {}", Thread.currentThread(), Clock.prettyTime(busy), Clock.prettyTime(total - busy));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processTask(TaskInfo taskInfo) {
            try {
                this.executeTask(taskInfo);
            }
            catch (Throwable e) {
                taskInfo.setExecutionFailure(e);
            }
            finally {
                this.taskExecutionPlan.taskComplete(taskInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeTask(TaskInfo taskInfo) {
            TaskInternal task = taskInfo.getTask();
            Object object = AbstractTaskPlanExecutor.this.lock;
            synchronized (object) {
                this.taskListener.beforeExecute(task);
            }
            try {
                task.executeWithoutThrowingTaskFailure();
            }
            finally {
                object = AbstractTaskPlanExecutor.this.lock;
                synchronized (object) {
                    this.taskListener.afterExecute(task, task.getState());
                }
            }
        }
    }
}

