/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
implements TaskInternal,
DynamicObjectAware {
    private static Logger buildLogger = Logging.getLogger(Task.class);
    private static ThreadLocal<TaskInfo> nextInstance = new ThreadLocal();
    private ProjectInternal project;
    private String name;
    private List<ContextAwareTaskAction> actions = new ArrayList<ContextAwareTaskAction>();
    private String path;
    private boolean enabled = true;
    private DefaultTaskDependency dependencies;
    private DefaultTaskDependency mustRunAfter;
    private DefaultTaskDependency finalizedBy;
    private DefaultTaskDependency shouldRunAfter;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private String group;
    private AndSpec<Task> onlyIfSpec = new AndSpec(new Spec[]{this.createNewOnlyIfSpec()});
    private TaskExecuter executer;
    private final ServiceRegistry services;
    private final TaskStateInternal state;
    private List<TaskValidator> validators = new ArrayList<TaskValidator>();
    private final TaskMutator taskMutator;
    private ObservableList observableActionList;

    protected AbstractTask() {
        this(AbstractTask.taskInfo());
    }

    private static TaskInfo taskInfo() {
        return nextInstance.get();
    }

    private AbstractTask(TaskInfo taskInfo) {
        if (taskInfo == null) {
            throw new TaskInstantiationException(String.format("Task of type '%s' has been instantiated directly which is not supported. Tasks can only be created using the DSL.", this.getClass().getName()));
        }
        this.project = taskInfo.project;
        this.name = taskInfo.name;
        assert (this.project != null);
        assert (this.name != null);
        this.path = this.project.absoluteProjectPath(this.name);
        this.state = new TaskStateInternal(this.toString());
        this.dependencies = new DefaultTaskDependency(this.project.getTasks());
        this.mustRunAfter = new DefaultTaskDependency(this.project.getTasks());
        this.finalizedBy = new DefaultTaskDependency(this.project.getTasks());
        this.shouldRunAfter = new DefaultTaskDependency(this.project.getTasks());
        this.services = this.project.getServiceRegistryFactory().createFor(this);
        this.extensibleDynamicObject = new ExtensibleDynamicObject(this, (Instantiator)this.services.get(Instantiator.class));
        this.taskMutator = (TaskMutator)this.services.get(TaskMutator.class);
        this.observableActionList = new ObservableActionWrapperList(this.actions);
        this.observableActionList.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTask.this.taskMutator.assertMutable("Task.getActions()", evt);
            }
        });
    }

    public static <T extends Task> T injectIntoNewInstance(ProjectInternal project, String name, Callable<T> factory) {
        nextInstance.set(new TaskInfo(project, name));
        try {
            Task task = (Task)factory.call();
            return (T)task;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            nextInstance.set(null);
        }
    }

    @Override
    public TaskStateInternal getState() {
        return this.state;
    }

    @Override
    public AntBuilder getAnt() {
        return this.project.getAnt();
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = (ProjectInternal)project;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Action<? super Task>> getActions() {
        return this.observableActionList;
    }

    @Override
    public List<ContextAwareTaskAction> getTaskActions() {
        return this.observableActionList;
    }

    @Override
    public void setActions(final List<Action<? super Task>> actions) {
        this.taskMutator.mutate("Task.setActions(List<Action>)", new Runnable(){

            public void run() {
                actions.clear();
                for (Action action : actions) {
                    AbstractTask.this.doLast((Action<? super Task>)action);
                }
            }
        });
    }

    @Override
    public TaskDependencyInternal getTaskDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<Object> getDependsOn() {
        return this.dependencies.getValues();
    }

    @Override
    public void setDependsOn(final Iterable<?> dependsOn) {
        this.taskMutator.mutate("Task.setDependsOn(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.dependencies.setValues(dependsOn);
            }
        });
    }

    @Override
    public void onlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.onlyIf(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(onlyIfClosure);
            }
        });
    }

    @Override
    public void onlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.onlyIf(Spec)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(new Spec[]{spec});
            }
        });
    }

    @Override
    public void setOnlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.setOnlyIf(Spec)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(new Spec[]{spec});
            }
        });
    }

    @Override
    public void setOnlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.setOnlyIf(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(onlyIfClosure);
            }
        });
    }

    private AndSpec<Task> createNewOnlyIfSpec() {
        return new AndSpec(new Spec[]{new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return element == AbstractTask.this && AbstractTask.this.enabled;
            }
        }});
    }

    @Override
    public Spec<? super TaskInternal> getOnlyIf() {
        return this.onlyIfSpec;
    }

    @Override
    public boolean getDidWork() {
        return this.state.getDidWork();
    }

    @Override
    public void setDidWork(boolean didWork) {
        this.state.setDidWork(didWork);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(final boolean enabled) {
        this.taskMutator.mutate("Task.setEnabled(boolean)", new Runnable(){

            public void run() {
                AbstractTask.this.enabled = enabled;
            }
        });
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Task deleteAllActions() {
        this.taskMutator.mutate("Task.deleteAllActions()", new Runnable(){

            public void run() {
                AbstractTask.this.actions.clear();
            }
        });
        return this;
    }

    @Override
    public final void execute() {
        this.executeWithoutThrowingTaskFailure();
        this.state.rethrowFailure();
    }

    @Override
    public void executeWithoutThrowingTaskFailure() {
        this.getExecuter().execute(this, this.state, new DefaultTaskExecutionContext());
    }

    @Override
    public TaskExecuter getExecuter() {
        if (this.executer == null) {
            this.executer = (TaskExecuter)this.services.get(TaskExecuter.class);
        }
        return this.executer;
    }

    @Override
    public void setExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public Task dependsOn(final Object ... paths) {
        this.taskMutator.mutate("Task.dependsOn(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.dependencies.add(paths);
            }
        });
        return this;
    }

    @Override
    public Task doFirst(final Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Action)", new Runnable(){

            public void run() {
                AbstractTask.this.actions.add(0, AbstractTask.this.wrap((Action<? super Task>)action));
            }
        });
        return this;
    }

    @Override
    public Task doLast(final Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Action)", new Runnable(){

            public void run() {
                AbstractTask.this.actions.add(AbstractTask.this.wrap((Action<? super Task>)action));
            }
        });
        return this;
    }

    @Override
    public int compareTo(Task otherTask) {
        int depthCompare = this.project.compareTo(otherTask.getProject());
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherTask.getPath());
        }
        return depthCompare;
    }

    public String toString() {
        return String.format("task '%s'", this.path);
    }

    @Override
    public Logger getLogger() {
        return buildLogger;
    }

    @Override
    @Inject
    public LoggingManagerInternal getLogging() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public ExtensionContainer getExtensions() {
        return this.getConvention();
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    @Inject
    public TaskInputs getInputs() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public TaskOutputsInternal getOutputs() {
        throw new UnsupportedOperationException();
    }

    protected ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public boolean dependsOnTaskDidWork() {
        TaskDependencyInternal dependency = this.getTaskDependencies();
        for (Task task : dependency.getDependencies(this)) {
            if (!task.getDidWork()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task doFirst(final Closure action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.actions.add(0, AbstractTask.this.convertClosureToAction(action));
            }
        });
        return this;
    }

    @Override
    public Task doLast(final Closure action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.actions.add(AbstractTask.this.convertClosureToAction(action));
            }
        });
        return this;
    }

    @Override
    public Task leftShift(final Closure action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.leftShit(Closure)", new Runnable(){

            public void run() {
                AbstractTask.this.actions.add(AbstractTask.this.taskMutator.leftShift(AbstractTask.this.convertClosureToAction(action)));
            }
        });
        return this;
    }

    @Override
    public Task configure(Closure closure) {
        return ConfigureUtil.configure(closure, this, false);
    }

    @Override
    public File getTemporaryDir() {
        File dir = ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).newTemporaryFile(this.getName());
        GFileUtils.mkdirs(dir);
        return dir;
    }

    @Override
    public Factory<File> getTemporaryDirFactory() {
        return new Factory<File>(){

            public File create() {
                return AbstractTask.this.getTemporaryDir();
            }
        };
    }

    @Override
    public void addValidator(TaskValidator validator) {
        this.validators.add(validator);
    }

    @Override
    public List<TaskValidator> getValidators() {
        return this.validators;
    }

    private ContextAwareTaskAction convertClosureToAction(Closure actionClosure) {
        return new ClosureTaskAction(actionClosure);
    }

    private ContextAwareTaskAction wrap(Action<? super Task> action) {
        if (action instanceof ContextAwareTaskAction) {
            return (ContextAwareTaskAction)action;
        }
        return new TaskActionWrapper(action);
    }

    @Override
    public void setMustRunAfter(final Iterable<?> mustRunAfterTasks) {
        this.taskMutator.mutate("Task.setMustRunAfter(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.mustRunAfter.setValues(mustRunAfterTasks);
            }
        });
    }

    @Override
    public Task mustRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.mustRunAfter(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.mustRunAfter.add(paths);
            }
        });
        return this;
    }

    @Override
    public TaskDependency getMustRunAfter() {
        return this.mustRunAfter;
    }

    @Override
    public void setFinalizedBy(final Iterable<?> finalizedByTasks) {
        this.taskMutator.mutate("Task.setFinalizedBy(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.finalizedBy.setValues(finalizedByTasks);
            }
        });
    }

    @Override
    public Task finalizedBy(final Object ... paths) {
        this.taskMutator.mutate("Task.finalizedBy(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.finalizedBy.add(paths);
            }
        });
        return this;
    }

    @Override
    public TaskDependency getFinalizedBy() {
        return this.finalizedBy;
    }

    @Override
    public TaskDependency shouldRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.shouldRunAfter(Object...)", new Runnable(){

            public void run() {
                AbstractTask.this.shouldRunAfter.add(paths);
            }
        });
        return this.shouldRunAfter;
    }

    @Override
    public void setShouldRunAfter(final Iterable<?> shouldRunAfterTasks) {
        this.taskMutator.mutate("Task.setShouldRunAfter(Iterable)", new Runnable(){

            public void run() {
                AbstractTask.this.shouldRunAfter.setValues(shouldRunAfterTasks);
            }
        });
    }

    @Override
    public TaskDependency getShouldRunAfter() {
        return this.shouldRunAfter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObservableActionWrapperList
    extends ObservableList {
        public ObservableActionWrapperList(List delegate) {
            super(delegate);
        }

        public boolean add(Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            return super.add((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        public void add(int index, Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            super.add(index, (Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        public boolean addAll(Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean addAll(int index, Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(index, this.transformToContextAwareTaskActions(actions));
        }

        public boolean removeAll(Collection actions) {
            return super.removeAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean remove(Object action) {
            return super.remove((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        private Collection<ContextAwareTaskAction> transformToContextAwareTaskActions(Collection<Object> c) {
            return Collections2.transform(c, (Function)new Function<Object, ContextAwareTaskAction>(){

                public ContextAwareTaskAction apply(@Nullable Object input) {
                    return AbstractTask.this.wrap((Action<? super Task>)((Action)input));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskActionWrapper
    implements ContextAwareTaskAction {
        private final Action<? super Task> action;

        public TaskActionWrapper(Action<? super Task> action) {
            this.action = action;
        }

        @Override
        public void contextualise(TaskExecutionContext context) {
            if (this.action instanceof ContextAwareTaskAction) {
                ((ContextAwareTaskAction)this.action).contextualise(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Task task) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute((Object)task);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TaskActionWrapper)) {
                return false;
            }
            TaskActionWrapper that = (TaskActionWrapper)o;
            return !(this.action != null ? !this.action.equals(that.action) : that.action != null);
        }

        public int hashCode() {
            return this.action != null ? this.action.hashCode() : 0;
        }
    }

    private static class ClosureTaskAction
    implements ContextAwareTaskAction {
        private final Closure closure;

        private ClosureTaskAction(Closure closure) {
            this.closure = closure;
        }

        public void contextualise(TaskExecutionContext context) {
        }

        public void execute(Task task) {
            this.closure.setDelegate((Object)task);
            this.closure.setResolveStrategy(1);
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.closure.getClass().getClassLoader());
            try {
                if (this.closure.getMaximumNumberOfParameters() == 0) {
                    this.closure.call();
                } else {
                    this.closure.call((Object)task);
                }
            }
            catch (InvokerInvocationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }

    private static class TaskInfo {
        private final ProjectInternal project;
        private final String name;

        private TaskInfo(ProjectInternal project, String name) {
            this.name = name;
            this.project = project;
        }
    }
}

