/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.upgrade;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdUpgradeClient
extends BaseSvnClient
implements UpgradeClient {
    private static final String STATUS = "\\s*(.+?)\\s*";
    private static final String PATH = "\\s*'(.*?)'\\s*";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(.+?)\\s*\\s*'(.*?)'\\s*");

    @Override
    public void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @Nullable ISVNEventHandler handler) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient", "upgrade"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient", "upgrade"));
        }
        this.validateFormat(format, this.getSupportedFormats());
        CmdUpgradeClient.callHandler(handler, CmdUpgradeClient.createEvent(path, SVNEventAction.UPDATE_COMPLETED));
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, path);
        FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new UpgradeStatusConvertor());
        UpgradeLineCommandListener listener = new UpgradeLineCommandListener(parser);
        CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.upgrade, parameters, listener);
        listener.throwIfException();
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
        result.add(WorkingCopyFormat.from(this.myFactory.createVersionClient().getVersion()));
        return result;
    }

    private static class UpgradeLineCommandListener
    extends LineCommandAdapter {
        @NotNull
        private final FileStatusResultParser parser;
        @NotNull
        private final AtomicReference<VcsException> exception;

        private UpgradeLineCommandListener(@NotNull FileStatusResultParser parser) {
            if (parser == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient$UpgradeLineCommandListener", "<init>"));
            }
            this.parser = parser;
            this.exception = new AtomicReference();
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                try {
                    this.parser.onLine(line);
                }
                catch (VcsException e) {
                    this.exception.set(e);
                }
            }
        }

        public void throwIfException() throws VcsException {
            VcsException e = this.exception.get();
            if (e != null) {
                throw e;
            }
        }
    }

    private static class UpgradeStatusConvertor
    implements Convertor<Matcher, SVNEvent> {
        private UpgradeStatusConvertor() {
        }

        public SVNEvent convert(@NotNull Matcher matcher) {
            if (matcher == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient$UpgradeStatusConvertor", "convert"));
            }
            String statusMessage = matcher.group(1);
            String path = matcher.group(2);
            return CmdUpgradeClient.createEvent(new File(path), UpgradeStatusConvertor.createAction(statusMessage));
        }

        @Nullable
        public static SVNEventAction createAction(@NotNull String code) {
            if (code == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient$UpgradeStatusConvertor", "createAction"));
            }
            SVNEventAction result = null;
            if ("Upgraded".equals(code)) {
                result = SVNEventAction.UPGRADED_PATH;
            }
            return result;
        }
    }
}

