/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.wm.StatusBar;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.SvnUpdateContext;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class UpdateEventHandler
implements ISVNEventHandler {
    private ProgressIndicator myProgressIndicator;
    private UpdatedFiles myUpdatedFiles;
    private int myExternalsCount;
    private final SvnVcs myVCS;
    @Nullable
    private final SvnUpdateContext mySequentialUpdatesContext;
    private final Map<File, SVNURL> myUrlToCheckForSwitch;
    protected String myText;
    protected String myText2;

    public UpdateEventHandler(SvnVcs vcs, ProgressIndicator progressIndicator, @Nullable SvnUpdateContext sequentialUpdatesContext) {
        this.myProgressIndicator = progressIndicator;
        this.myVCS = vcs;
        this.mySequentialUpdatesContext = sequentialUpdatesContext;
        this.myExternalsCount = 1;
        this.myUrlToCheckForSwitch = new HashMap<File, SVNURL>();
    }

    public void addToSwitch(File file, SVNURL url) {
        this.myUrlToCheckForSwitch.put(file, url);
    }

    public void setUpdatedFiles(UpdatedFiles updatedFiles) {
        this.myUpdatedFiles = updatedFiles;
    }

    public void handleEvent(SVNEvent event, double progress) {
        if (event == null || event.getFile() == null) {
            return;
        }
        String path = event.getFile().getAbsolutePath();
        String displayPath = event.getFile().getName();
        this.myText2 = null;
        this.myText = null;
        if (this.handleInDescendants(event)) {
            this.updateProgressIndicator();
            return;
        }
        if (event.getAction() == SVNEventAction.TREE_CONFLICT) {
            this.myText2 = SvnBundle.message("progress.text2.treeconflicted", displayPath);
            this.updateProgressIndicator();
            this.myUpdatedFiles.registerGroup(UpdateEventHandler.createFileGroup(VcsBundle.message((String)"update.group.name.merged.with.tree.conflicts", (Object[])new Object[0]), "MERGED_WITH_TREE_CONFLICT"));
            this.addFileToGroup("MERGED_WITH_TREE_CONFLICT", event);
        }
        if (event.getAction() == SVNEventAction.UPDATE_ADD || event.getAction() == SVNEventAction.ADD) {
            this.myText2 = SvnBundle.message("progress.text2.added", displayPath);
            if (event.getContentsStatus() == SVNStatusType.CONFLICTED || event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                this.addFileToGroup("MERGED_WITH_CONFLICTS", event);
                this.myText2 = SvnBundle.message("progress.text2.conflicted", displayPath);
            } else if (this.myUpdatedFiles.getGroupById("REMOVED_FROM_REPOSITORY").getFiles().contains(path)) {
                this.myUpdatedFiles.getGroupById("REMOVED_FROM_REPOSITORY").getFiles().remove(path);
                if (this.myUpdatedFiles.getGroupById("replaced") == null) {
                    this.myUpdatedFiles.registerGroup(UpdateEventHandler.createFileGroup(SvnBundle.message("status.group.name.replaced", new Object[0]), "replaced"));
                }
                this.addFileToGroup("replaced", event);
            } else {
                this.addFileToGroup("CREATED", event);
            }
        } else {
            if (event.getAction() == SVNEventAction.UPDATE_NONE) {
                return;
            }
            if (event.getAction() == SVNEventAction.UPDATE_DELETE) {
                this.myText2 = SvnBundle.message("progress.text2.deleted", displayPath);
                this.addFileToGroup("REMOVED_FROM_REPOSITORY", event);
            } else if (event.getAction() == SVNEventAction.UPDATE_UPDATE) {
                this.possiblySwitched(event);
                if (event.getContentsStatus() == SVNStatusType.CONFLICTED || event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                    if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                        this.addFileToGroup("MERGED_WITH_CONFLICTS", event);
                    }
                    if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                        this.addFileToGroup("MERGED_WITH_PROPERTY_CONFLICT", event);
                    }
                    this.myText2 = SvnBundle.message("progress.text2.conflicted", displayPath);
                } else if (event.getContentsStatus() == SVNStatusType.MERGED || event.getPropertiesStatus() == SVNStatusType.MERGED) {
                    this.myText2 = SvnBundle.message("progres.text2.merged", displayPath);
                    this.addFileToGroup("MERGED", event);
                } else if (event.getContentsStatus() == SVNStatusType.CHANGED || event.getPropertiesStatus() == SVNStatusType.CHANGED) {
                    this.myText2 = SvnBundle.message("progres.text2.updated", displayPath);
                    this.addFileToGroup("UPDATED", event);
                } else if (event.getContentsStatus() == SVNStatusType.UNCHANGED && (event.getPropertiesStatus() == SVNStatusType.UNCHANGED || event.getPropertiesStatus() == SVNStatusType.UNKNOWN)) {
                    this.myText2 = SvnBundle.message("progres.text2.updated", displayPath);
                } else if (SVNStatusType.INAPPLICABLE.equals(event.getContentsStatus()) && (event.getPropertiesStatus() == SVNStatusType.UNCHANGED || event.getPropertiesStatus() == SVNStatusType.UNKNOWN)) {
                    this.myText2 = SvnBundle.message("progres.text2.updated", displayPath);
                } else {
                    this.myText2 = "";
                    this.addFileToGroup("UNKNOWN", event);
                }
            } else if (event.getAction() == SVNEventAction.UPDATE_EXTERNAL) {
                if (this.mySequentialUpdatesContext != null) {
                    this.mySequentialUpdatesContext.registerExternalRootBeingUpdated(event.getFile());
                }
                ++this.myExternalsCount;
                if (this.myUpdatedFiles.getGroupById("external") == null) {
                    this.myUpdatedFiles.registerGroup(new FileGroup(SvnBundle.message("status.group.name.externals", new Object[0]), SvnBundle.message("status.group.name.externals", new Object[0]), false, "external", true));
                }
                this.addFileToGroup("external", event);
                this.myText = SvnBundle.message("progress.text.updating.external.location", event.getFile().getAbsolutePath());
            } else if (event.getAction() == SVNEventAction.RESTORE) {
                this.myText2 = SvnBundle.message("progress.text2.restored.file", displayPath);
                this.addFileToGroup("RESTORED", event);
            } else if (event.getAction() == SVNEventAction.UPDATE_COMPLETED && event.getRevision() >= 0L) {
                this.possiblySwitched(event);
                --this.myExternalsCount;
                this.myText2 = SvnBundle.message("progres.text2.updated.to.revision", event.getRevision());
                if (this.myExternalsCount == 0) {
                    this.myExternalsCount = 1;
                    StatusBar.Info.set((String)SvnBundle.message("status.text.updated.to.revision", event.getRevision()), (Project)this.myVCS.getProject());
                }
            } else if (event.getAction() == SVNEventAction.SKIP) {
                this.myText2 = SvnBundle.message("progress.text2.skipped.file", displayPath);
                this.addFileToGroup("SKIPPED", event);
            }
        }
        this.updateProgressIndicator();
    }

    private void possiblySwitched(SVNEvent event) {
        File file = event.getFile();
        if (file == null) {
            return;
        }
        SVNURL wasUrl = this.myUrlToCheckForSwitch.get(file);
        if (wasUrl != null && !wasUrl.equals((Object)event.getURL())) {
            this.myUrlToCheckForSwitch.remove(file);
            this.addFileToGroup("SWITCHED", event);
        }
    }

    private boolean itemSwitched(SVNEvent event) {
        File file = event.getFile();
        SvnFileUrlMapping urlMapping = this.myVCS.getSvnFileUrlMapping();
        SVNURL currentUrl = urlMapping.getUrlForFile(file);
        return currentUrl != null && !currentUrl.equals((Object)event.getURL());
    }

    private void updateProgressIndicator() {
        if (this.myProgressIndicator != null) {
            if (this.myText != null) {
                this.myProgressIndicator.setText(this.myText);
            }
            if (this.myText2 != null) {
                this.myProgressIndicator.setText2(this.myText2);
            }
        }
    }

    protected boolean handleInDescendants(SVNEvent event) {
        return false;
    }

    protected void addFileToGroup(String id, SVNEvent event) {
        FileGroup fileGroup = this.myUpdatedFiles.getGroupById(id);
        String path = event.getFile().getAbsolutePath();
        fileGroup.add(path, SvnVcs.getKey(), (VcsRevisionNumber)new SvnRevisionNumber(SVNRevision.create((long)event.getRevision())));
        if (event.getErrorMessage() != null) {
            fileGroup.addError(path, event.getErrorMessage().getMessage());
        }
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.checkCanceled();
            if (this.myProgressIndicator.isCanceled()) {
                SVNErrorManager.cancel((String)SvnBundle.message("exception.text.update.operation.cancelled", new Object[0]), (SVNLogType)SVNLogType.DEFAULT);
            }
        }
    }

    private static FileGroup createFileGroup(String name, String id) {
        return new FileGroup(name, name, false, id, true);
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator;
    }
}

