/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.AbstractSvnUpdateIntegrateEnvironment;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;
import org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler;
import org.jetbrains.idea.svn.update.SvnUpdateConfigurable;
import org.jetbrains.idea.svn.update.SvnUpdatePanel;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.jetbrains.idea.svn.update.UpdateRootInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnUpdateEnvironment
extends AbstractSvnUpdateIntegrateEnvironment {
    public SvnUpdateEnvironment(SvnVcs vcs) {
        super(vcs);
    }

    @Override
    protected AbstractUpdateIntegrateCrawler createCrawler(UpdateEventHandler eventHandler, boolean totalUpdate, ArrayList<VcsException> exceptions, UpdatedFiles updatedFiles) {
        return new UpdateCrawler(this.myVcs, eventHandler, totalUpdate, exceptions, updatedFiles);
    }

    @Override
    public Configurable createConfigurable(final Collection<FilePath> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        return new SvnUpdateConfigurable(this.myVcs.getProject()){

            public String getDisplayName() {
                return SvnBundle.message("update.switch.configurable.name", new Object[0]);
            }

            @Override
            protected AbstractSvnUpdatePanel createPanel() {
                return new SvnUpdatePanel(SvnUpdateEnvironment.this.myVcs, collection);
            }
        };
    }

    @Nullable
    private static SVNURL getSourceUrl(SvnVcs vcs, File root) {
        SVNInfo svnInfo = vcs.getInfo(root);
        return svnInfo != null ? svnInfo.getURL() : null;
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNRevision correctRevision(UpdateRootInfo value, SVNURL url, SVNRevision updateRevision) throws SVNException {
        if (SVNRevision.HEAD.equals((Object)value.getRevision())) {
            SVNRepository repository = null;
            try {
                repository = this.myVcs.createRepository(url);
                long longRevision = repository.getLatestRevision();
                SVNRevision newRevision = SVNRevision.create((long)longRevision);
                value.setRevision(newRevision);
                SVNRevision sVNRevision = newRevision;
                return sVNRevision;
            }
            finally {
                if (repository != null) {
                    repository.closeSession();
                }
            }
        }
        return updateRevision;
    }

    private boolean checkAncestry(File sourceFile, SVNURL targetUrl, SVNRevision targetRevision) throws SVNException {
        SVNInfo sourceSvnInfo = this.myVcs.getInfo(sourceFile);
        SVNInfo targetSvnInfo = this.myVcs.getInfo(targetUrl, targetRevision);
        if (sourceSvnInfo == null || targetSvnInfo == null) {
            return true;
        }
        SVNURL copyFromTarget = targetSvnInfo.getCopyFromURL();
        SVNURL copyFromSource = sourceSvnInfo.getCopyFromURL();
        if ((copyFromSource != null || copyFromTarget != null) && (sourceSvnInfo.getURL().equals((Object)copyFromTarget) || targetUrl.equals((Object)copyFromSource))) {
            return true;
        }
        int result = Messages.showYesNoDialog((Project)this.myVcs.getProject(), (String)SvnBundle.message("switch.target.not.copy.current", new Object[0]), (String)SvnBundle.message("switch.target.problem.title", new Object[0]), (Icon)Messages.getWarningIcon());
        return 0 == result;
    }

    protected static class UpdateCrawler
    extends AbstractUpdateIntegrateCrawler {
        public UpdateCrawler(SvnVcs vcs, UpdateEventHandler handler, boolean totalUpdate, Collection<VcsException> exceptions, UpdatedFiles postUpdateFiles) {
            super(totalUpdate, postUpdateFiles, exceptions, handler, vcs);
        }

        @Override
        protected void showProgressMessage(ProgressIndicator progress, File root) {
            progress.setText(SvnBundle.message("progress.text.updating", root.getAbsolutePath()));
        }

        @Override
        protected long doUpdate(File root) throws SVNException {
            long rev;
            SVNRevision updateTo;
            SvnConfiguration configuration = SvnConfiguration.getInstance(this.myVcs.getProject());
            UpdateRootInfo rootInfo = configuration.getUpdateRootInfo(root, this.myVcs);
            SVNURL sourceUrl = SvnUpdateEnvironment.getSourceUrl(this.myVcs, root);
            boolean isSwitch = rootInfo != null && rootInfo.getUrl() != null && !rootInfo.getUrl().equals((Object)sourceUrl);
            SVNRevision sVNRevision = updateTo = rootInfo != null && rootInfo.isUpdateToRevision() ? rootInfo.getRevision() : SVNRevision.HEAD;
            if (isSwitch) {
                UpdateClient updateClient = this.createUpdateClient(configuration, root, true, sourceUrl);
                this.myHandler.addToSwitch(root, sourceUrl);
                rev = updateClient.doSwitch(root, rootInfo.getUrl(), SVNRevision.UNDEFINED, updateTo, configuration.getUpdateDepth(), configuration.isForceUpdate(), false);
            } else {
                UpdateClient updateClient = this.createUpdateClient(configuration, root, false, sourceUrl);
                rev = updateClient.doUpdate(root, updateTo, configuration.getUpdateDepth(), configuration.isForceUpdate(), false);
            }
            this.myPostUpdateFiles.setRevisions(root.getAbsolutePath(), (AbstractVcs)this.myVcs, (VcsRevisionNumber)new SvnRevisionNumber(SVNRevision.create((long)rev)));
            return rev;
        }

        private UpdateClient createUpdateClient(SvnConfiguration configuration, File root, boolean isSwitch, SVNURL sourceUrl) {
            UpdateClient updateClient = this.myVcs.getFactory(root).createUpdateClient();
            if (!isSwitch) {
                updateClient.setIgnoreExternals(configuration.isIgnoreExternals());
            }
            updateClient.setEventHandler(this.myHandler);
            updateClient.setUpdateLocksOnDemand(configuration.isUpdateLockOnDemand());
            return updateClient;
        }

        @Override
        protected boolean isMerge() {
            return false;
        }
    }
}

