/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SvnKitUpdateClient
extends BaseSvnClient
implements UpdateClient {
    @Nullable
    protected ISVNEventHandler myDispatcher;
    protected boolean myIgnoreExternals;
    protected boolean myLocksOnDemand;

    @Override
    public long[] doUpdate(File[] paths, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky, boolean makeParents) throws SVNException {
        return this.getClient().doUpdate(paths, revision, depth, allowUnversionedObstructions, depthIsSticky, makeParents);
    }

    @Override
    public long doUpdate(File path, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        return this.getClient().doUpdate(path, revision, depth, allowUnversionedObstructions, depthIsSticky);
    }

    @Override
    public long doSwitch(File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        return this.getClient().doSwitch(path, url, pegRevision, revision, depth, allowUnversionedObstructions, depthIsSticky);
    }

    @Override
    public void setUpdateLocksOnDemand(boolean locksOnDemand) {
        this.myLocksOnDemand = locksOnDemand;
    }

    @Override
    public void setEventHandler(ISVNEventHandler dispatcher) {
        this.myDispatcher = dispatcher;
    }

    @Override
    public void setIgnoreExternals(boolean ignoreExternals) {
        this.myIgnoreExternals = ignoreExternals;
    }

    @NotNull
    private SVNUpdateClient getClient() {
        SVNUpdateClient client = this.myVcs.createUpdateClient();
        client.setEventHandler(this.myDispatcher);
        client.setIgnoreExternals(this.myIgnoreExternals);
        client.setUpdateLocksOnDemand(this.myLocksOnDemand);
        SVNUpdateClient sVNUpdateClient = client;
        if (sVNUpdateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/update/SvnKitUpdateClient", "getClient"));
        }
        return sVNUpdateClient;
    }
}

