/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandLineInfoClient;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.update.SvnKitUpdateClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdUpdateClient
extends SvnKitUpdateClient {
    private static final Pattern ourExceptionPattern = Pattern.compile("svn: E(\\d{6}): .+");
    private static final String ourAuthenticationRealm = "Authentication realm:";

    @Override
    public long[] doUpdate(File[] paths, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky, boolean makeParents) throws SVNException {
        this.checkWorkingCopy(paths[0]);
        ArrayList<String> parameters = new ArrayList<String>();
        CmdUpdateClient.fillParameters(parameters, revision, depth, depthIsSticky, allowUnversionedObstructions);
        CommandUtil.put(parameters, makeParents, "--parents");
        CommandUtil.put(parameters, this.myIgnoreExternals, "--ignore-externals");
        CommandUtil.put(parameters, paths);
        return this.run(paths, parameters, SvnCommandName.up);
    }

    private void checkWorkingCopy(@NotNull File path) throws SVNException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/update/CmdUpdateClient", "checkWorkingCopy"));
        }
        SvnCommandLineInfoClient infoClient = new SvnCommandLineInfoClient(this.myVcs);
        SVNInfo info = infoClient.doInfo(path, SVNRevision.UNDEFINED);
        if (info == null || info.getURL() == null) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_WORKING_COPY, (String)path.getPath()));
        }
    }

    private long[] run(@NotNull File[] paths, @NotNull List<String> parameters, @NotNull SvnCommandName command) throws SVNException {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/update/CmdUpdateClient", "run"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/update/CmdUpdateClient", "run"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/update/CmdUpdateClient", "run"));
        }
        File base = paths[0];
        base = base.isDirectory() ? base : base.getParentFile();
        AtomicReference<long[]> updatedToRevision = new AtomicReference<long[]>();
        updatedToRevision.set(new long[0]);
        BaseUpdateCommandListener listener = this.createCommandListener(paths, updatedToRevision, base);
        try {
            CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)base), command, parameters, listener);
        }
        catch (VcsException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e));
        }
        listener.throwIfException();
        return updatedToRevision.get();
    }

    private BaseUpdateCommandListener createCommandListener(final File[] paths, final AtomicReference<long[]> updatedToRevision, File base) {
        return new BaseUpdateCommandListener(base, this.myDispatcher){
            final long[] myRevisions;
            {
                super(x0, x1);
                this.myRevisions = new long[paths.length];
            }

            @Override
            protected void beforeHandler(@NotNull SVNEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/update/CmdUpdateClient$1", "beforeHandler"));
                }
                if (SVNEventAction.UPDATE_COMPLETED.equals(event.getAction())) {
                    long eventRevision = event.getRevision();
                    for (int i = 0; i < paths.length; ++i) {
                        File path = paths[i];
                        if (!FileUtil.filesEqual((File)path, (File)event.getFile())) continue;
                        this.myRevisions[i] = eventRevision;
                        break;
                    }
                }
            }

            @Override
            public void processTerminated(int exitCode) {
                super.processTerminated(exitCode);
                updatedToRevision.set(this.myRevisions);
            }
        };
    }

    private static void fillParameters(@NotNull List<String> parameters, @Nullable SVNRevision revision, @Nullable SVNDepth depth, boolean depthIsSticky, boolean allowUnversionedObstructions) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/update/CmdUpdateClient", "fillParameters"));
        }
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth, depthIsSticky);
        CommandUtil.put(parameters, allowUnversionedObstructions, "--force");
        parameters.add("--accept");
        parameters.add("postpone");
    }

    private void checkForException(StringBuffer sbError) throws SVNException {
        String group;
        if (sbError.length() == 0) {
            return;
        }
        String message = sbError.toString();
        Matcher matcher = ourExceptionPattern.matcher(message);
        if (matcher.matches() && (group = matcher.group(1)) != null) {
            try {
                int code = Integer.parseInt(group);
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.getErrorCode((int)code), (String)message));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (message.contains(ourAuthenticationRealm)) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_UNAVAILABLE, (String)message));
        }
        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)message));
    }

    @Override
    public long doUpdate(File path, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        long[] longs = this.doUpdate(new File[]{path}, revision, depth, allowUnversionedObstructions, depthIsSticky, false);
        return longs[0];
    }

    @Override
    public long doSwitch(File path, SVNURL url, SVNRevision pegRevision, SVNRevision revision, SVNDepth depth, boolean allowUnversionedObstructions, boolean depthIsSticky) throws SVNException {
        this.checkWorkingCopy(path);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, SvnTarget.fromURL((SVNURL)url, (SVNRevision)pegRevision));
        CommandUtil.put(parameters, path, false);
        CmdUpdateClient.fillParameters(parameters, revision, depth, depthIsSticky, allowUnversionedObstructions);
        parameters.add("--ignore-ancestry");
        long[] revisions = this.run(new File[]{path}, parameters, SvnCommandName.switchCopy);
        return revisions != null && revisions.length > 0 ? revisions[0] : -1L;
    }
}

