/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.io.File;
import java.util.Collection;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;

public abstract class AbstractUpdateIntegrateCrawler
implements SvnWCRootCrawler {
    protected final SvnVcs myVcs;
    protected final UpdateEventHandler myHandler;
    protected final Collection<VcsException> myExceptions;
    protected final UpdatedFiles myPostUpdateFiles;
    protected final boolean myIsTotalUpdate;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler");

    protected AbstractUpdateIntegrateCrawler(boolean isTotalUpdate, UpdatedFiles postUpdateFiles, Collection<VcsException> exceptions, UpdateEventHandler handler, SvnVcs vcs) {
        this.myIsTotalUpdate = isTotalUpdate;
        this.myPostUpdateFiles = postUpdateFiles;
        this.myExceptions = exceptions;
        this.myHandler = handler;
        this.myVcs = vcs;
    }

    @Override
    public void handleWorkingCopyRoot(File root, ProgressIndicator progress) {
        if (progress != null) {
            this.showProgressMessage(progress, root);
        }
        try {
            long rev = this.doUpdate(root);
            if (rev < 0L && !this.isMerge()) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)SvnBundle.message("exception.text.root.was.not.properly.updated", root)));
            }
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            this.myExceptions.add(new VcsException((Throwable)e));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            this.myExceptions.add(e);
        }
    }

    protected abstract void showProgressMessage(ProgressIndicator var1, File var2);

    protected abstract long doUpdate(File var1) throws SVNException, VcsException;

    protected abstract boolean isMerge();
}

