/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdPropertyClient
extends BaseSvnClient
implements PropertyClient {
    @Override
    @Nullable
    public SVNPropertyData getProperty(@NotNull SvnTarget target, @NotNull String property, boolean revisionProperty, @Nullable SVNRevision revision) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(property);
        if (!revisionProperty) {
            CommandUtil.put(parameters, target);
            CommandUtil.put(parameters, revision);
        } else {
            this.assertFile(target);
            CommandUtil.put(parameters, target, false);
            parameters.add("--revprop");
            CommandUtil.put(parameters, this.resolveRevisionNumber(target.getFile(), revision));
        }
        parameters.add("--xml");
        CommandExecutor command = CommandUtil.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
        return this.parseSingleProperty(target, command.getOutput());
    }

    @Override
    public void getProperty(@NotNull SvnTarget target, @NotNull String property, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable ISVNPropertyHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "getProperty"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(property);
        this.fillListParameters(target, revision, depth, parameters, false);
        CommandExecutor command = CommandUtil.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
        CmdPropertyClient.parseOutput(target, command.getOutput(), handler);
    }

    @Override
    public void list(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable ISVNPropertyHandler handler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "list"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        this.fillListParameters(target, revision, depth, parameters, true);
        CommandExecutor command = CommandUtil.execute(this.myVcs, target, SvnCommandName.proplist, parameters, null);
        CmdPropertyClient.parseOutput(target, command.getOutput(), handler);
    }

    @Override
    public void setProperty(@NotNull File file, @NotNull String property, @Nullable SVNPropertyValue value, @Nullable SVNDepth depth, boolean force) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperty"));
        }
        this.runSetProperty(SvnTarget.fromFile((File)file), property, null, depth, value, force);
    }

    @Override
    public void setProperties(@NotNull File file, @NotNull SVNProperties properties) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperties"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setProperties"));
        }
        SVNProperties currentProperties = this.collectPropertiesToDelete(file);
        currentProperties.putAll(properties);
        for (String propertyName : currentProperties.nameSet()) {
            this.setProperty(file, propertyName, currentProperties.getSVNPropertyValue(propertyName), SVNDepth.EMPTY, true);
        }
    }

    @NotNull
    private SVNProperties collectPropertiesToDelete(@NotNull File file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "collectPropertiesToDelete"));
        }
        final SVNProperties result = new SVNProperties();
        this.list(SvnTarget.fromFile((File)file), null, SVNDepth.EMPTY, new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                result.put(property.getName(), (SVNPropertyValue)null);
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
            }

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            }
        });
        SVNProperties sVNProperties = result;
        if (sVNProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "collectPropertiesToDelete"));
        }
        return sVNProperties;
    }

    @Override
    public void setRevisionProperty(@NotNull SvnTarget target, @NotNull String property, @NotNull SVNRevision revision, @Nullable SVNPropertyValue value, boolean force) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setRevisionProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setRevisionProperty"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "setRevisionProperty"));
        }
        this.runSetProperty(target, property, revision, null, value, force);
    }

    private void runSetProperty(@NotNull SvnTarget target, @NotNull String property, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @Nullable SVNPropertyValue value, boolean force) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "runSetProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "runSetProperty"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        boolean isDelete = value == null;
        parameters.add(property);
        if (revision != null) {
            parameters.add("--revprop");
            CommandUtil.put(parameters, revision);
        }
        if (!isDelete) {
            parameters.add(SVNPropertyValue.getPropertyAsString((SVNPropertyValue)value));
            CommandUtil.put(parameters, force, "--force");
        }
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, depth);
        CommandUtil.execute(this.myVcs, target, CommandUtil.getHomeDirectory(), isDelete ? SvnCommandName.propdel : SvnCommandName.propset, parameters, null);
    }

    private void fillListParameters(@NotNull SvnTarget target, @Nullable SVNRevision revision, @Nullable SVNDepth depth, @NotNull List<String> parameters, boolean verbose) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "fillListParameters"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "fillListParameters"));
        }
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandUtil.put(parameters, verbose, "--verbose");
    }

    private SVNPropertyData parseSingleProperty(SvnTarget target, String output) throws VcsException {
        final SVNPropertyData[] data = new SVNPropertyData[1];
        ISVNPropertyHandler handler = new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                data[0] = property;
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                data[0] = property;
            }

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                data[0] = property;
            }
        };
        CmdPropertyClient.parseOutput(target, output, handler);
        return data[0];
    }

    private static void parseOutput(SvnTarget target, String output, ISVNPropertyHandler handler) throws VcsException {
        try {
            Properties properties = CommandUtil.parse(output, Properties.class);
            if (properties != null) {
                for (Target childInfo : properties.targets) {
                    SvnTarget childTarget = CmdPropertyClient.append(target, childInfo.path);
                    for (Property property : childInfo.properties) {
                        CmdPropertyClient.invokeHandler(childTarget, CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
                if (properties.revisionProperties != null) {
                    for (Property property : properties.revisionProperties.properties) {
                        CmdPropertyClient.invokeHandler(properties.revisionProperties.revisionNumber(), CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static SvnTarget append(@NotNull SvnTarget target, @NotNull String path) throws SVNException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "append"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "append"));
        }
        SvnTarget result = target.isFile() ? SvnTarget.fromFile((File)(FileUtil.isAbsolute((String)path) ? new File(path) : new File(target.getFile(), path))) : SvnTarget.fromURL((SVNURL)target.getURL().appendPath(path, false));
        return result;
    }

    private static void invokeHandler(@NotNull SvnTarget target, @Nullable SVNPropertyData data, @Nullable ISVNPropertyHandler handler) throws SVNException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "invokeHandler"));
        }
        if (handler != null && data != null) {
            if (target.isFile()) {
                handler.handleProperty(target.getFile(), data);
            } else {
                handler.handleProperty(target.getURL(), data);
            }
        }
    }

    private static void invokeHandler(long revision, @Nullable SVNPropertyData data, @Nullable ISVNPropertyHandler handler) throws SVNException {
        if (handler != null && data != null) {
            handler.handleProperty(revision, data);
        }
    }

    @Nullable
    private static SVNPropertyData create(@NotNull String property, @Nullable String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "create"));
        }
        SVNPropertyData result = null;
        if (value != null) {
            result = new SVNPropertyData(property, SVNPropertyValue.create((String)value.trim()), LF_SEPARATOR_OPTIONS);
        }
        return result;
    }

    private SVNRevision resolveRevisionNumber(@NotNull File path, @Nullable SVNRevision revision) throws VcsException {
        long result;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/properties/CmdPropertyClient", "resolveRevisionNumber"));
        }
        long l = result = revision != null ? revision.getNumber() : -1L;
        if (SVNRevision.BASE.equals((Object)revision)) {
            SVNInfo info = this.myVcs.getInfo(path, SVNRevision.BASE);
            long l2 = result = info != null ? info.getRevision().getNumber() : -1L;
        }
        if (result == -1L) {
            throw new VcsException("Could not determine revision number for file " + path + " and revision " + revision);
        }
        return SVNRevision.create((long)result);
    }

    public static class Property {
        @XmlAttribute(name="name")
        public String name;
        @XmlValue
        public String value;
    }

    public static class RevisionProperties {
        @XmlAttribute(name="rev")
        public String revision;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();

        public long revisionNumber() {
            return Long.valueOf(this.revision);
        }
    }

    public static class Target {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();
    }

    @XmlRootElement(name="properties")
    public static class Properties {
        @XmlElement(name="target")
        public List<Target> targets = new ArrayList<Target>();
        @XmlElement(name="revprops")
        public RevisionProperties revisionProperties;
    }
}

