/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.portable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Getter;
import java.io.File;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class PortableStatus
extends SVNStatus {
    private static final Logger LOG = Logger.getInstance(PortableStatus.class);
    private boolean myConflicted;
    private Getter<SVNInfo> myInfoGetter;
    private SVNInfo myInfo;
    private String myPath;
    private boolean myFileExists;

    public PortableStatus(SVNURL url, File file, SVNNodeKind kind, SVNRevision revision, SVNRevision committedRevision, Date committedDate, String author, SVNStatusType contentsStatus, SVNStatusType propertiesStatus, SVNStatusType remoteContentsStatus, SVNStatusType remotePropertiesStatus, boolean isLocked, boolean isCopied, boolean isSwitched, boolean isFileExternal, SVNLock remoteLock, SVNLock localLock, Map entryProperties, String changelistName, int wcFormatVersion, boolean isConflicted, Getter<SVNInfo> infoGetter) {
        super(url, file, kind, revision, committedRevision, committedDate, author, contentsStatus, propertiesStatus, remoteContentsStatus, remotePropertiesStatus, isLocked, isCopied, isSwitched, isFileExternal, null, null, null, null, null, null, remoteLock, localLock, entryProperties, changelistName, wcFormatVersion, null);
        this.myConflicted = isConflicted;
        this.myInfoGetter = infoGetter == null ? new Getter<SVNInfo>(){

            public SVNInfo get() {
                return null;
            }
        } : infoGetter;
    }

    public PortableStatus() {
        this.myInfoGetter = new Getter<SVNInfo>(){

            public SVNInfo get() {
                return null;
            }
        };
        this.setCommittedRevision(SVNRevision.UNDEFINED);
    }

    public int getWorkingCopyFormat() {
        LOG.error("Do not use working copy format detection through status");
        return 0;
    }

    public void setIsConflicted(boolean isConflicted) {
        this.myConflicted = isConflicted;
        super.setIsConflicted(isConflicted);
    }

    public void setConflicted(boolean conflicted) {
        this.myConflicted = conflicted;
    }

    public void setInfoGetter(Getter<SVNInfo> infoGetter) {
        this.myInfoGetter = infoGetter;
    }

    public boolean isConflicted() {
        return this.myConflicted;
    }

    private SVNInfo initInfo() {
        if (this.myInfo == null) {
            SVNStatusType contentsStatus = this.getContentsStatus();
            if (contentsStatus == null || SVNStatusType.UNKNOWN.equals(contentsStatus)) {
                return null;
            }
            this.myInfo = (SVNInfo)this.myInfoGetter.get();
        }
        return this.myInfo;
    }

    public SVNInfo getInfo() {
        return this.initInfo();
    }

    public SVNNodeKind getKind() {
        if (this.myFileExists) {
            return super.getKind();
        }
        SVNInfo info = this.initInfo();
        if (info != null) {
            return info.getKind();
        }
        return super.getKind();
    }

    public File getConflictNewFile() {
        if (!this.isConflicted()) {
            return null;
        }
        SVNInfo info = this.initInfo();
        return info == null ? null : info.getConflictNewFile();
    }

    public File getConflictOldFile() {
        if (!this.isConflicted()) {
            return null;
        }
        SVNInfo info = this.initInfo();
        return info == null ? null : info.getConflictOldFile();
    }

    public File getConflictWrkFile() {
        if (!this.isConflicted()) {
            return null;
        }
        SVNInfo info = this.initInfo();
        return info == null ? null : info.getConflictWrkFile();
    }

    public File getPropRejectFile() {
        if (!this.isConflicted()) {
            return null;
        }
        SVNInfo info = this.initInfo();
        return info == null ? null : info.getPropConflictFile();
    }

    public String getCopyFromURL() {
        if (!this.isCopied()) {
            return null;
        }
        SVNInfo info = this.initInfo();
        if (info == null) {
            return null;
        }
        SVNURL url = this.initInfo().getCopyFromURL();
        return url == null ? null : url.toString();
    }

    public SVNURL getURL() {
        SVNURL url = super.getURL();
        if (url == null) {
            SVNInfo info = this.initInfo();
            url = info != null ? info.getURL() : url;
        }
        return url;
    }

    public SVNURL getRepositoryRootURL() {
        SVNURL url = super.getRepositoryRootURL();
        if (url == null) {
            SVNInfo info = this.initInfo();
            url = info != null ? info.getRepositoryRootURL() : url;
        }
        return url;
    }

    public File getFile() {
        File file = super.getFile();
        if (file == null) {
            SVNInfo info = this.initInfo();
            file = info != null ? info.getFile() : file;
        }
        return file;
    }

    public SVNRevision getRevision() {
        SVNRevision revision = super.getRevision();
        if (revision != null && revision.isValid()) {
            return revision;
        }
        SVNStatusType status = this.getContentsStatus();
        if (SVNStatusType.STATUS_NONE.equals(status) || SVNStatusType.STATUS_UNVERSIONED.equals(status) || SVNStatusType.STATUS_ADDED.equals(status)) {
            return revision;
        }
        SVNInfo info = this.initInfo();
        return info == null ? revision : info.getRevision();
    }

    public SVNRevision getCopyFromRevision() {
        if (!this.isCopied()) {
            return null;
        }
        SVNInfo info = this.initInfo();
        return info == null ? null : info.getCopyFromRevision();
    }

    public SVNTreeConflictDescription getTreeConflict() {
        if (!this.isConflicted()) {
            return null;
        }
        SVNInfo info = this.initInfo();
        return info == null ? null : info.getTreeConflict();
    }

    public void setPath(String path) {
        this.myPath = path;
    }

    public String getPath() {
        return this.myPath;
    }

    public void setKind(boolean exists, SVNNodeKind kind) {
        this.myFileExists = exists;
        this.setKind(kind);
    }
}

