/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.lock.LockClient;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdLockClient
extends BaseSvnClient
implements LockClient {
    @Override
    public void lock(@NotNull File file, boolean force, @NotNull String message, @Nullable ISVNEventHandler handler) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/CmdLockClient", "lock"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/lock/CmdLockClient", "lock"));
        }
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        parameters.add("--message");
        parameters.add(message);
        CommandExecutor command = CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)file), SvnCommandName.lock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, SVNEventAction.LOCKED, SVNEventAction.LOCK_FAILED, handler);
    }

    @Override
    public void unlock(@NotNull File file, boolean force, @Nullable ISVNEventHandler handler) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/CmdLockClient", "unlock"));
        }
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        CommandExecutor command = CommandUtil.execute(this.myVcs, SvnTarget.fromFile((File)file), SvnCommandName.unlock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, SVNEventAction.UNLOCKED, SVNEventAction.UNLOCK_FAILED, handler);
    }

    private static List<String> prepareParameters(@NotNull File file, boolean force) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/CmdLockClient", "prepareParameters"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, file);
        CommandUtil.put(parameters, force, "--force");
        return parameters;
    }

    private static void handleCommandCompletion(@NotNull CommandExecutor command, @NotNull File file, @NotNull SVNEventAction success, @NotNull SVNEventAction failure, @Nullable ISVNEventHandler handler) throws VcsException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        if (success == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        if (failure == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/svn/lock/CmdLockClient", "handleCommandCompletion"));
        }
        SVNErrorMessage error = SvnUtil.parseWarning(command.getErrorOutput());
        try {
            CmdLockClient.invokeHandler(file, error == null ? success : failure, handler, error);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(@NotNull File file, @NotNull SVNEventAction action, @Nullable ISVNEventHandler handler, @Nullable SVNErrorMessage error) throws SVNException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/CmdLockClient", "invokeHandler"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/lock/CmdLockClient", "invokeHandler"));
        }
        if (handler != null) {
            handler.handleEvent(CmdLockClient.createEvent(file, action, error), 1.0);
        }
    }

    private static SVNEvent createEvent(@NotNull File file, @NotNull SVNEventAction action, @Nullable SVNErrorMessage error) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/lock/CmdLockClient", "createEvent"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/lock/CmdLockClient", "createEvent"));
        }
        return new SVNEvent(file, file.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.FILE, null, -1L, null, null, null, null, action, action, error, null, null, null, null);
    }
}

