/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitMergeClient
extends BaseSvnClient
implements MergeClient {
    @Override
    public void merge(@NotNull SvnTarget source, @NotNull File destination, boolean dryRun, @Nullable SVNDiffOptions diffOptions, @Nullable ISVNEventHandler handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        this.assertUrl(source);
        try {
            this.createClient(diffOptions, handler).doMergeReIntegrate(source.getURL(), source.getPegRevision(), destination, dryRun);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public void merge(@NotNull SvnTarget source, @NotNull SVNRevisionRange range, @NotNull File destination, @Nullable SVNDepth depth, boolean dryRun, boolean recordOnly, boolean force, @Nullable SVNDiffOptions diffOptions, @Nullable ISVNEventHandler handler) throws VcsException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        this.assertUrl(source);
        try {
            this.createClient(diffOptions, handler).doMerge(source.getURL(), source.getPegRevision(), Collections.singletonList(range), destination, depth, true, force, dryRun, recordOnly);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Override
    public void merge(@NotNull SvnTarget source1, @NotNull SvnTarget source2, @NotNull File destination, @Nullable SVNDepth depth, boolean useAncestry, boolean dryRun, boolean recordOnly, boolean force, @Nullable SVNDiffOptions diffOptions, @Nullable ISVNEventHandler handler) throws VcsException {
        if (source1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (source2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "merge"));
        }
        this.assertUrl(source1);
        this.assertUrl(source2);
        try {
            this.createClient(diffOptions, handler).doMerge(source1.getURL(), source1.getPegRevision(), source2.getURL(), source2.getPegRevision(), destination, depth, useAncestry, force, dryRun, recordOnly);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    private SVNDiffClient createClient(@Nullable SVNDiffOptions diffOptions, @Nullable ISVNEventHandler handler) {
        SVNDiffClient client = this.myVcs.createDiffClient();
        client.setMergeOptions(diffOptions);
        client.setEventHandler(handler);
        SVNDiffClient sVNDiffClient = client;
        if (sVNDiffClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/SvnKitMergeClient", "createClient"));
        }
        return sVNDiffClient;
    }
}

