/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.integrate.Merger;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class PointMerger
extends Merger {
    private final List<Change> mySelectedChanges;
    private final SvnVcs myVcs;
    private final UpdateEventHandler myHandler;

    public PointMerger(SvnVcs vcs, CommittedChangeList selectedChangeList, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, List<Change> selectedChanges, String branchName) {
        super(vcs, new ArrayList<CommittedChangeList>(Arrays.asList(selectedChangeList)), target, handler, currentBranchUrl, branchName);
        this.myHandler = handler;
        this.myVcs = vcs;
        this.mySelectedChanges = selectedChanges;
        Collections.sort(this.mySelectedChanges, ChangesComparator.getInstance());
        this.myLatestProcessed = selectedChangeList;
    }

    @Override
    public boolean hasNext() {
        return this.myCount == 0;
    }

    @Override
    protected void doMerge() throws SVNException, VcsException {
        for (Change change : this.mySelectedChanges) {
            if (change.getBeforeRevision() == null) {
                this.add(change);
                continue;
            }
            if (change.getAfterRevision() == null) {
                this.delete(change);
                continue;
            }
            this.merge(change);
        }
    }

    private void merge(Change change) throws SVNException, VcsException {
        SvnRepositoryContentRevision before = (SvnRepositoryContentRevision)change.getBeforeRevision();
        SvnRepositoryContentRevision after = (SvnRepositoryContentRevision)change.getAfterRevision();
        String path = this.myCurrentBranchUrl.toString();
        String beforeUrl = before.getFullPath();
        String afterUrl = after.getFullPath();
        File afterPath = SvnUtil.fileFromUrl(this.myTarget, path, afterUrl);
        MergeClient client = this.myVcs.getFactory(this.myTarget).createMergeClient();
        SvnTarget source1 = SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)beforeUrl), (SVNRevision)((SvnRevisionNumber)before.getRevisionNumber()).getRevision());
        SvnTarget source2 = SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)afterUrl), (SVNRevision)((SvnRevisionNumber)after.getRevisionNumber()).getRevision());
        client.merge(source1, source2, afterPath, SVNDepth.FILES, true, this.mySvnConfig.isMergeDryRun(), false, false, this.mySvnConfig.getMergeOptions(), this.myHandler);
    }

    private void delete(Change change) throws SVNException, VcsException {
        SvnRepositoryContentRevision before = (SvnRepositoryContentRevision)change.getBeforeRevision();
        String path = this.myCurrentBranchUrl.toString();
        String beforeUrl = before.getFullPath();
        File beforePath = SvnUtil.fileFromUrl(this.myTarget, path, beforeUrl);
        DeleteClient client = this.myVcs.getFactory(this.myTarget).createDeleteClient();
        client.delete(beforePath, false, this.mySvnConfig.isMergeDryRun(), this.myHandler);
    }

    private void add(Change change) throws SVNException, VcsException {
        SvnRepositoryContentRevision after = (SvnRepositoryContentRevision)change.getAfterRevision();
        String path = this.myCurrentBranchUrl.toString();
        String afterUrl = after.getFullPath();
        File afterPath = SvnUtil.fileFromUrl(this.myTarget, path, afterUrl);
        SVNRevision revision = ((SvnRevisionNumber)after.getRevisionNumber()).getRevision();
        CopyMoveClient client = this.myVcs.getFactory(this.myTarget).createCopyMoveClient();
        client.copy(SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)afterUrl), (SVNRevision)revision), afterPath, revision, true, this.myHandler);
    }

    @Override
    @Nullable
    public File getMergeInfoHolder() {
        return null;
    }

    private static class ChangesComparator
    implements Comparator<Change> {
        private static final ChangesComparator ourInstance = new ChangesComparator();

        private ChangesComparator() {
        }

        public static ChangesComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(Change o1, Change o2) {
            SvnRepositoryContentRevision after1 = (SvnRepositoryContentRevision)o1.getAfterRevision();
            SvnRepositoryContentRevision after2 = (SvnRepositoryContentRevision)o2.getAfterRevision();
            if (after1 == null) {
                return 1;
            }
            if (after2 == null) {
                return -1;
            }
            String path1 = after1.getFullPath();
            String path2 = after2.getFullPath();
            if (path1 == null) {
                return 1;
            }
            if (path2 == null) {
                return -1;
            }
            String ancestor = SVNPathUtil.getCommonPathAncestor((String)path1, (String)path2);
            return path1.equals(ancestor) ? -1 : 1;
        }
    }
}

