/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class Merger
implements IMerger {
    protected final List<CommittedChangeList> myChangeLists;
    protected final File myTarget;
    @Nullable
    private final ISVNEventHandler myHandler;
    protected int myCount;
    private final ProgressIndicator myProgressIndicator;
    protected CommittedChangeList myLatestProcessed;
    protected final SVNURL myCurrentBranchUrl;
    private final StringBuilder myCommitMessage;
    protected final SvnConfiguration mySvnConfig;
    private final Project myProject;
    @NotNull
    private final SvnVcs myVcs;
    private final String myBranchName;
    public static final Topic<CommittedChangesMergedStateChanged> COMMITTED_CHANGES_MERGED_STATE = new Topic("COMMITTED_CHANGES_MERGED_STATE", CommittedChangesMergedStateChanged.class);

    public Merger(SvnVcs vcs, List<CommittedChangeList> changeLists, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
        this.myBranchName = branchName;
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.mySvnConfig = SvnConfiguration.getInstance(vcs.getProject());
        this.myCurrentBranchUrl = currentBranchUrl;
        this.myChangeLists = changeLists;
        Collections.sort(this.myChangeLists, ByNumberChangeListComparator.getInstance());
        this.myTarget = target;
        this.myCount = 0;
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        this.myHandler = handler;
        this.myCommitMessage = new StringBuilder();
    }

    @Override
    public boolean hasNext() {
        return this.myCount < this.myChangeLists.size();
    }

    @Override
    public void mergeNext() throws SVNException, VcsException {
        this.myLatestProcessed = this.myChangeLists.get(this.myCount);
        ++this.myCount;
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setText2(SvnBundle.message("action.Subversion.integrate.changes.progress.integrating.details.text", this.myLatestProcessed.getNumber()));
        }
        this.doMerge();
        this.appendComment();
    }

    private void appendComment() {
        String nextComment;
        if (this.myCommitMessage.length() == 0) {
            this.myCommitMessage.append("Merged from ").append(this.myBranchName);
        }
        if ((nextComment = this.myLatestProcessed.getComment()).trim().length() > 0) {
            this.myCommitMessage.append('\n').append(nextComment).append(" [from revision ").append(this.myLatestProcessed.getNumber()).append("]");
        }
    }

    protected SVNRevisionRange createRange() {
        return new SVNRevisionRange(SVNRevision.create((long)(this.myLatestProcessed.getNumber() - 1L)), SVNRevision.create((long)this.myLatestProcessed.getNumber()));
    }

    protected boolean isRecordOnly() {
        return false;
    }

    protected void doMerge() throws SVNException, VcsException {
        SvnTarget source = SvnTarget.fromURL((SVNURL)this.myCurrentBranchUrl);
        MergeClient client = this.myVcs.getFactory(this.myTarget).createMergeClient();
        client.merge(source, this.createRange(), this.myTarget, SVNDepth.INFINITY, this.mySvnConfig.isMergeDryRun(), this.isRecordOnly(), true, this.mySvnConfig.getMergeOptions(), this.myHandler);
    }

    @NonNls
    private List<CommittedChangeList> getTail() {
        return this.myCount < this.myChangeLists.size() ? new ArrayList<CommittedChangeList>(this.myChangeLists.subList(this.myCount, this.myChangeLists.size())) : Collections.emptyList();
    }

    @Override
    public void getInfo(Consumer<String> holder, boolean getLatest) {
        if (getLatest && this.myLatestProcessed != null) {
            holder.consume((Object)SvnBundle.message("action.Subversion.integrate.changes.warning.failed.list.text", this.myLatestProcessed.getNumber(), this.myLatestProcessed.getComment().replace('\n', '|')));
        }
        this.getSkipped(holder);
    }

    @Override
    public void getSkipped(Consumer<String> holder) {
        List<CommittedChangeList> tail = this.getTail();
        if (!tail.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tail.size(); ++i) {
                CommittedChangeList list = tail.get(i);
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(list.getNumber()).append(" (").append(list.getComment().replace('\n', '|')).append(')');
            }
            holder.consume((Object)SvnBundle.message("action.Subversion.integrate.changes.warning.skipped.lists.text", sb.toString()));
        }
    }

    @Override
    public String getComment() {
        return this.myCommitMessage.toString();
    }

    @Override
    @Nullable
    public File getMergeInfoHolder() {
        return this.myTarget;
    }

    @Override
    public void afterProcessing() {
        ((CommittedChangesMergedStateChanged)this.myProject.getMessageBus().syncPublisher(COMMITTED_CHANGES_MERGED_STATE)).event(new ArrayList<CommittedChangeList>(this.myChangeLists.subList(0, this.myCount)));
    }

    public static interface CommittedChangesMergedStateChanged {
        public void event(List<CommittedChangeList> var1);
    }

    private static class ByNumberChangeListComparator
    implements Comparator<CommittedChangeList> {
        private static final ByNumberChangeListComparator ourInstance = new ByNumberChangeListComparator();

        private ByNumberChangeListComparator() {
        }

        public static ByNumberChangeListComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(CommittedChangeList o1, CommittedChangeList o2) {
            return (int)(o1.getNumber() - o2.getNumber());
        }
    }
}

