/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class WcInfoLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history.WcInfoLoader");
    private final Project myProject;
    private final RepositoryLocation myLocation;

    public WcInfoLoader(Project project, RepositoryLocation location) {
        this.myProject = project;
        this.myLocation = location;
    }

    public List<WCInfoWithBranches> loadRoots() {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        if (vcs == null) {
            return Collections.emptyList();
        }
        SvnFileUrlMapping urlMapping = vcs.getSvnFileUrlMapping();
        List<WCInfo> wcInfoList = vcs.getAllWcInfos();
        ArrayList<WCInfoWithBranches> result = new ArrayList<WCInfoWithBranches>();
        for (WCInfo info : wcInfoList) {
            WCInfoWithBranches wcInfoWithBranches = this.createInfo(info, vcs, urlMapping);
            if (wcInfoWithBranches == null) continue;
            result.add(wcInfoWithBranches);
        }
        return result;
    }

    @Nullable
    public WCInfoWithBranches reloadInfo(WCInfoWithBranches info) {
        File file;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        if (vcs == null) {
            return null;
        }
        SvnFileUrlMapping urlMapping = vcs.getSvnFileUrlMapping();
        RootUrlInfo rootInfo = urlMapping.getWcRootForFilePath(file = new File(info.getPath()));
        if (rootInfo == null) {
            return null;
        }
        WCInfo wcInfo = new WCInfo(rootInfo, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(vcs, file));
        return this.createInfo(wcInfo, vcs, urlMapping);
    }

    @Nullable
    private WCInfoWithBranches createInfo(WCInfo info, SvnVcs vcs, SvnFileUrlMapping urlMapping) {
        SvnBranchConfigurationNew configuration;
        if (!info.getFormat().supportsMergeInfo()) {
            return null;
        }
        String url = info.getUrl().toString();
        if (this.myLocation != null && !this.myLocation.toPresentableString().startsWith(url) && !url.startsWith(this.myLocation.toPresentableString())) {
            return null;
        }
        if (!SvnUtil.checkRepositoryVersion15(vcs, url)) {
            return null;
        }
        RootUrlInfo rootForUrl = urlMapping.getWcRootForUrl(url);
        if (rootForUrl == null) {
            return null;
        }
        VirtualFile root = rootForUrl.getRoot();
        VirtualFile wcRoot = rootForUrl.getVirtualFile();
        if (wcRoot == null) {
            return null;
        }
        try {
            configuration = SvnBranchConfigurationManager.getInstance(this.myProject).get(wcRoot);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            return null;
        }
        if (configuration == null) {
            return null;
        }
        ArrayList<WCInfoWithBranches.Branch> items = new ArrayList<WCInfoWithBranches.Branch>();
        String branchRoot = WcInfoLoader.createBranchesList(url, configuration, items);
        return new WCInfoWithBranches(info, items, root, branchRoot);
    }

    private static String createBranchesList(String url, SvnBranchConfigurationNew configuration, List<WCInfoWithBranches.Branch> items) {
        String result = null;
        String trunkUrl = configuration.getTrunkUrl();
        if (trunkUrl != null && !SVNPathUtil.isAncestor((String)trunkUrl, (String)url)) {
            items.add(new WCInfoWithBranches.Branch(trunkUrl));
        } else if (trunkUrl != null) {
            result = trunkUrl;
        }
        for (String branchUrl : configuration.getBranchUrls()) {
            for (SvnBranchItem branchItem : configuration.getBranches(branchUrl)) {
                if (!SVNPathUtil.isAncestor((String)branchItem.getUrl(), (String)url)) {
                    items.add(new WCInfoWithBranches.Branch(branchItem.getUrl()));
                    continue;
                }
                result = branchItem.getUrl();
            }
        }
        Collections.sort(items, new Comparator<WCInfoWithBranches.Branch>(){

            @Override
            public int compare(WCInfoWithBranches.Branch o1, WCInfoWithBranches.Branch o2) {
                return Comparing.compare((Comparable)((Object)o1.getUrl()), (Comparable)((Object)o2.getUrl()));
            }
        });
        return result;
    }
}

