/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnLogLoader;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnLogUtil
implements SvnLogLoader {
    private final Project myProject;
    private final SvnVcs myVcs;
    private final SvnRepositoryLocation myLocation;
    private final SVNURL myRepositoryRoot;

    public SvnLogUtil(Project project, SvnVcs vcs, SvnRepositoryLocation location, SVNURL repositoryRoot) {
        this.myProject = project;
        this.myVcs = vcs;
        this.myLocation = location;
        this.myRepositoryRoot = repositoryRoot;
    }

    @Override
    public List<CommittedChangeList> loadInterval(SVNRevision fromIncluding, SVNRevision toIncluding, int maxCount, boolean includingYoungest, boolean includeOldest) throws VcsException {
        ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
        ISVNLogEntryHandler handler = this.createLogHandler(fromIncluding, toIncluding, includingYoungest, includeOldest, result);
        SvnTarget target = SvnTarget.fromURL((SVNURL)this.myLocation.toSvnUrl());
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, fromIncluding, toIncluding, true, true, false, maxCount, null, handler);
        return result;
    }

    @NotNull
    private ISVNLogEntryHandler createLogHandler(final SVNRevision fromIncluding, final SVNRevision toIncluding, final boolean includingYoungest, final boolean includeOldest, final List<CommittedChangeList> result) {
        ISVNLogEntryHandler iSVNLogEntryHandler = new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                if (SvnLogUtil.this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress != null) {
                    progress.setText2(SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
                    progress.checkCanceled();
                }
                if (!includingYoungest && logEntry.getRevision() == fromIncluding.getNumber()) {
                    return;
                }
                if (!includeOldest && logEntry.getRevision() == toIncluding.getNumber()) {
                    return;
                }
                result.add(new SvnChangeList(SvnLogUtil.this.myVcs, SvnLogUtil.this.myLocation, logEntry, SvnLogUtil.this.myRepositoryRoot.toString()));
            }
        };
        if (iSVNLogEntryHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnLogUtil", "createLogHandler"));
        }
        return iSVNLogEntryHandler;
    }
}

