/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdHistoryClient
extends BaseSvnClient
implements HistoryClient {
    /*
     * WARNING - void declaration
     */
    @Override
    public void doLog(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, @Nullable String[] revisionProperties, @Nullable ISVNLogEntryHandler iSVNLogEntryHandler) throws VcsException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/history/CmdHistoryClient", "doLog"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/history/CmdHistoryClient", "doLog"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/history/CmdHistoryClient", "doLog"));
        }
        List<String> parameters = CmdHistoryClient.prepareCommand(target, startRevision, endRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit);
        try {
            void handler;
            CommandExecutor command = CommandUtil.execute(this.myVcs, target, SvnCommandName.log, parameters, null);
            CmdHistoryClient.parseOutput(command, (ISVNLogEntryHandler)handler);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private static void parseOutput(@NotNull CommandExecutor command, @Nullable ISVNLogEntryHandler handler) throws VcsException, SVNException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/history/CmdHistoryClient", "parseOutput"));
        }
        try {
            LogInfo log = CommandUtil.parse(command.getOutput(), LogInfo.class);
            if (handler != null && log != null) {
                for (LogEntry entry : log.entries) {
                    CmdHistoryClient.iterateRecursively(entry, handler);
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void iterateRecursively(@NotNull LogEntry entry, @NotNull ISVNLogEntryHandler handler) throws SVNException {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/history/CmdHistoryClient", "iterateRecursively"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/history/CmdHistoryClient", "iterateRecursively"));
        }
        handler.handleLogEntry(entry.toLogEntry());
        for (LogEntry childEntry : entry.childEntries) {
            CmdHistoryClient.iterateRecursively(childEntry, handler);
        }
        if (entry.hasChildren()) {
            handler.handleLogEntry(SVNLogEntry.EMPTY_ENTRY);
        }
    }

    private static List<String> prepareCommand(@NotNull SvnTarget target, @NotNull SVNRevision startRevision, @NotNull SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/history/CmdHistoryClient", "prepareCommand"));
        }
        if (startRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/idea/svn/history/CmdHistoryClient", "prepareCommand"));
        }
        if (endRevision == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/history/CmdHistoryClient", "prepareCommand"));
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        parameters.add("--revision");
        parameters.add(startRevision + ":" + endRevision);
        CommandUtil.put(parameters, stopOnCopy, "--stop-on-copy");
        CommandUtil.put(parameters, discoverChangedPaths, "--verbose");
        CommandUtil.put(parameters, includeMergedRevisions, "--use-merge-history");
        if (limit > 0L) {
            parameters.add("--limit");
            parameters.add(String.valueOf(limit));
        }
        parameters.add("--xml");
        return parameters;
    }

    public static class ChangedPath {
        @XmlAttribute(name="kind")
        public String kind;
        @XmlAttribute(name="action")
        public String action;
        @XmlAttribute(name="copyfrom-path")
        public String copyFromPath;
        @XmlAttribute(name="copyfrom-rev")
        public long copyFromRevision;
        @XmlValue
        public String path;

        public SVNLogEntryPath toLogEntryPath() {
            return new SVNLogEntryPath(this.path, CommandUtil.getStatusChar(this.action), this.copyFromPath, this.copyFromRevision);
        }
    }

    public static class ChangedPaths {
        @XmlElement(name="path")
        public List<ChangedPath> changedPaths = new ArrayList<ChangedPath>();

        public Map<String, SVNLogEntryPath> toMap() {
            HashMap changes = ContainerUtil.newHashMap();
            for (ChangedPath path : this.changedPaths) {
                changes.put(path.path, path.toLogEntryPath());
            }
            return changes;
        }
    }

    public static class LogEntry {
        @XmlAttribute(name="revision")
        public long revision;
        @XmlElement(name="author")
        public String author;
        @XmlElement(name="date")
        public Date date;
        @XmlElement(name="msg")
        public String message;
        @XmlElement(name="paths")
        public ChangedPaths changedPaths;
        @XmlElement(name="logentry")
        public List<LogEntry> childEntries = new ArrayList<LogEntry>();

        public boolean hasChildren() {
            return !this.childEntries.isEmpty();
        }

        public SVNLogEntry toLogEntry() {
            SVNLogEntry entry = new SVNLogEntry(this.toChangedPathsMap(), this.revision, this.author, this.date, this.message);
            entry.setHasChildren(this.hasChildren());
            return entry;
        }

        public Map<String, SVNLogEntryPath> toChangedPathsMap() {
            return this.changedPaths != null ? this.changedPaths.toMap() : ContainerUtil.newHashMap();
        }
    }

    @XmlRootElement(name="log")
    public static class LogInfo {
        @XmlElement(name="logentry")
        public List<LogEntry> entries = new ArrayList<LogEntry>();
    }
}

