/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.browser.AbstractOpeningExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;

public class UrlOpeningExpander
extends AbstractOpeningExpander {
    private final String myUrl;

    UrlOpeningExpander(@NotNull RepositoryBrowserComponent browser, String selectionPath, @NotNull String url) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/idea/svn/dialogs/browser/UrlOpeningExpander", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/dialogs/browser/UrlOpeningExpander", "<init>"));
        }
        super(browser, selectionPath);
        this.myUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    @Override
    protected AbstractOpeningExpander.ExpandVariants expandNode(String url) {
        if (this.myUrl.equals(url)) {
            return AbstractOpeningExpander.ExpandVariants.EXPAND_AND_EXIT;
        }
        if (this.myUrl.startsWith(url.endsWith("/") ? url : url + '/')) {
            return AbstractOpeningExpander.ExpandVariants.EXPAND_CONTINUE;
        }
        return AbstractOpeningExpander.ExpandVariants.DO_NOTHING;
    }

    @Override
    protected boolean checkChild(String childUrl) {
        return this.myUrl.startsWith(childUrl);
    }

    public static class Factory
    implements NotNullFunction<RepositoryBrowserComponent, Expander> {
        private final String myUrl;
        private final String mySelectionUrl;

        public Factory(String url, String selectionUrl) {
            this.myUrl = url;
            this.mySelectionUrl = selectionUrl;
        }

        @NotNull
        public Expander fun(RepositoryBrowserComponent repositoryBrowserComponent) {
            UrlOpeningExpander urlOpeningExpander = new UrlOpeningExpander(repositoryBrowserComponent, this.mySelectionUrl, this.myUrl);
            if (urlOpeningExpander == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/browser/UrlOpeningExpander$Factory", "fun"));
            }
            return urlOpeningExpander;
        }
    }
}

